/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.util.ArrayList;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.util.HtmlUtils;

public class EscapedErrors
implements Errors {
    private final Errors source;

    public EscapedErrors(Errors source2) {
        Assert.notNull((Object)source2, "Errors source must not be null");
        this.source = source2;
    }

    public Errors getSource() {
        return this.source;
    }

    @Override
    public String getObjectName() {
        return this.source.getObjectName();
    }

    @Override
    public void setNestedPath(String nestedPath) {
        this.source.setNestedPath(nestedPath);
    }

    @Override
    public String getNestedPath() {
        return this.source.getNestedPath();
    }

    @Override
    public void pushNestedPath(String subPath) {
        this.source.pushNestedPath(subPath);
    }

    @Override
    public void popNestedPath() throws IllegalStateException {
        this.source.popNestedPath();
    }

    @Override
    public void reject(String errorCode) {
        this.source.reject(errorCode);
    }

    @Override
    public void reject(String errorCode, String defaultMessage) {
        this.source.reject(errorCode, defaultMessage);
    }

    @Override
    public void reject(String errorCode, @Nullable Object[] errorArgs, @Nullable String defaultMessage) {
        this.source.reject(errorCode, errorArgs, defaultMessage);
    }

    @Override
    public void rejectValue(@Nullable String field, String errorCode) {
        this.source.rejectValue(field, errorCode);
    }

    @Override
    public void rejectValue(@Nullable String field, String errorCode, String defaultMessage) {
        this.source.rejectValue(field, errorCode, defaultMessage);
    }

    @Override
    public void rejectValue(@Nullable String field, String errorCode, @Nullable Object[] errorArgs, @Nullable String defaultMessage) {
        this.source.rejectValue(field, errorCode, errorArgs, defaultMessage);
    }

    @Override
    public void addAllErrors(Errors errors) {
        this.source.addAllErrors(errors);
    }

    @Override
    public boolean hasErrors() {
        return this.source.hasErrors();
    }

    @Override
    public int getErrorCount() {
        return this.source.getErrorCount();
    }

    @Override
    public List<ObjectError> getAllErrors() {
        return this.escapeObjectErrors(this.source.getAllErrors());
    }

    @Override
    public boolean hasGlobalErrors() {
        return this.source.hasGlobalErrors();
    }

    @Override
    public int getGlobalErrorCount() {
        return this.source.getGlobalErrorCount();
    }

    @Override
    public List<ObjectError> getGlobalErrors() {
        return this.escapeObjectErrors(this.source.getGlobalErrors());
    }

    @Override
    @Nullable
    public ObjectError getGlobalError() {
        return this.escapeObjectError(this.source.getGlobalError());
    }

    @Override
    public boolean hasFieldErrors() {
        return this.source.hasFieldErrors();
    }

    @Override
    public int getFieldErrorCount() {
        return this.source.getFieldErrorCount();
    }

    @Override
    public List<FieldError> getFieldErrors() {
        return this.source.getFieldErrors();
    }

    @Override
    @Nullable
    public FieldError getFieldError() {
        return this.source.getFieldError();
    }

    @Override
    public boolean hasFieldErrors(String field) {
        return this.source.hasFieldErrors(field);
    }

    @Override
    public int getFieldErrorCount(String field) {
        return this.source.getFieldErrorCount(field);
    }

    @Override
    public List<FieldError> getFieldErrors(String field) {
        return this.escapeObjectErrors(this.source.getFieldErrors(field));
    }

    @Override
    @Nullable
    public FieldError getFieldError(String field) {
        return this.escapeObjectError(this.source.getFieldError(field));
    }

    @Override
    @Nullable
    public Object getFieldValue(String field) {
        Object object;
        Object value2 = this.source.getFieldValue(field);
        if (value2 instanceof String) {
            String text = (String)value2;
            object = HtmlUtils.htmlEscape(text);
        } else {
            object = value2;
        }
        return object;
    }

    @Override
    @Nullable
    public Class<?> getFieldType(String field) {
        return this.source.getFieldType(field);
    }

    @Nullable
    private <T extends ObjectError> T escapeObjectError(@Nullable T source2) {
        if (source2 == null) {
            return null;
        }
        String defaultMessage = source2.getDefaultMessage();
        if (defaultMessage != null) {
            defaultMessage = HtmlUtils.htmlEscape(defaultMessage);
        }
        if (source2 instanceof FieldError) {
            FieldError fieldError = (FieldError)source2;
            Object value2 = fieldError.getRejectedValue();
            if (value2 instanceof String) {
                String text = (String)value2;
                value2 = HtmlUtils.htmlEscape(text);
            }
            return (T)new FieldError(fieldError.getObjectName(), fieldError.getField(), value2, fieldError.isBindingFailure(), fieldError.getCodes(), fieldError.getArguments(), defaultMessage);
        }
        return (T)new ObjectError(source2.getObjectName(), source2.getCodes(), source2.getArguments(), defaultMessage);
    }

    private <T extends ObjectError> List<T> escapeObjectErrors(List<T> source2) {
        ArrayList<ObjectError> escaped = new ArrayList<ObjectError>(source2.size());
        for (ObjectError objectError : source2) {
            escaped.add(this.escapeObjectError(objectError));
        }
        return escaped;
    }
}

