/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web;

import jakarta.servlet.ServletException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.ErrorResponse;

public class HttpRequestMethodNotSupportedException
extends ServletException
implements ErrorResponse {
    private final String method;
    @Nullable
    private final String[] supportedMethods;
    private final ProblemDetail body;

    public HttpRequestMethodNotSupportedException(String method2) {
        this(method2, (String[])null);
    }

    public HttpRequestMethodNotSupportedException(String method2, @Nullable Collection<String> supportedMethods) {
        this(method2, supportedMethods != null ? StringUtils.toStringArray(supportedMethods) : null);
    }

    private HttpRequestMethodNotSupportedException(String method2, @Nullable String[] supportedMethods) {
        super("Request method '" + method2 + "' is not supported");
        this.method = method2;
        this.supportedMethods = supportedMethods;
        String detail = "Method '" + method2 + "' is not supported.";
        this.body = ProblemDetail.forStatusAndDetail(this.getStatusCode(), detail);
    }

    public String getMethod() {
        return this.method;
    }

    @Nullable
    public String[] getSupportedMethods() {
        return this.supportedMethods;
    }

    @Nullable
    public Set<HttpMethod> getSupportedHttpMethods() {
        if (this.supportedMethods == null) {
            return null;
        }
        LinkedHashSet<HttpMethod> supportedMethods = new LinkedHashSet<HttpMethod>(this.supportedMethods.length);
        for (String value2 : this.supportedMethods) {
            HttpMethod method2 = HttpMethod.valueOf(value2);
            supportedMethods.add(method2);
        }
        return supportedMethods;
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatus.METHOD_NOT_ALLOWED;
    }

    @Override
    public HttpHeaders getHeaders() {
        if (ObjectUtils.isEmpty(this.supportedMethods)) {
            return HttpHeaders.EMPTY;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Allow", StringUtils.arrayToDelimitedString(this.supportedMethods, ", "));
        return headers;
    }

    @Override
    public ProblemDetail getBody() {
        return this.body;
    }

    @Override
    public Object[] getDetailMessageArguments() {
        return new Object[]{this.getMethod(), this.getSupportedHttpMethods()};
    }
}

