/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web;

import java.net.URI;
import org.springframework.core.NestedRuntimeException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.lang.Nullable;
import org.springframework.web.ErrorResponse;

public class ErrorResponseException
extends NestedRuntimeException
implements ErrorResponse {
    private final HttpStatusCode status;
    private final HttpHeaders headers = new HttpHeaders();
    private final ProblemDetail body;
    private final String messageDetailCode;
    @Nullable
    private final Object[] messageDetailArguments;

    public ErrorResponseException(HttpStatusCode status2) {
        this(status2, null);
    }

    public ErrorResponseException(HttpStatusCode status2, @Nullable Throwable cause2) {
        this(status2, ProblemDetail.forStatus(status2), cause2);
    }

    public ErrorResponseException(HttpStatusCode status2, ProblemDetail body2, @Nullable Throwable cause2) {
        this(status2, body2, cause2, null, null);
    }

    public ErrorResponseException(HttpStatusCode status2, ProblemDetail body2, @Nullable Throwable cause2, @Nullable String messageDetailCode, @Nullable Object[] messageDetailArguments) {
        super(null, cause2);
        this.status = status2;
        this.body = body2;
        this.messageDetailCode = this.initMessageDetailCode(messageDetailCode);
        this.messageDetailArguments = messageDetailArguments;
    }

    private String initMessageDetailCode(@Nullable String messageDetailCode) {
        return messageDetailCode != null ? messageDetailCode : ErrorResponse.getDefaultDetailMessageCode(this.getClass(), null);
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return this.status;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public void setType(URI type2) {
        this.body.setType(type2);
    }

    public void setTitle(@Nullable String title) {
        this.body.setTitle(title);
    }

    public void setDetail(@Nullable String detail) {
        this.body.setDetail(detail);
    }

    public void setInstance(@Nullable URI instance) {
        this.body.setInstance(instance);
    }

    @Override
    public final ProblemDetail getBody() {
        return this.body;
    }

    @Override
    public String getDetailMessageCode() {
        return this.messageDetailCode;
    }

    @Override
    @Nullable
    public Object[] getDetailMessageArguments() {
        return this.messageDetailArguments;
    }

    @Override
    public String getMessage() {
        return this.status + (String)(!this.headers.isEmpty() ? ", headers=" + this.headers : "") + ", " + this.body;
    }
}

