/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.support;

import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.validation.BindingResult;

public class BindingAwareModelMap
extends ExtendedModelMap {
    @Override
    public Object put(String key2, @Nullable Object value2) {
        this.removeBindingResultIfNecessary(key2, value2);
        return super.put(key2, value2);
    }

    @Override
    public void putAll(Map<? extends String, ?> map2) {
        map2.forEach(this::removeBindingResultIfNecessary);
        super.putAll(map2);
    }

    private void removeBindingResultIfNecessary(Object key2, @Nullable Object value2) {
        String bindingResultKey;
        BindingResult bindingResult;
        String attributeName;
        if (key2 instanceof String && !(attributeName = (String)key2).startsWith(BindingResult.MODEL_KEY_PREFIX) && (bindingResult = (BindingResult)this.get(bindingResultKey = BindingResult.MODEL_KEY_PREFIX + attributeName)) != null && bindingResult.getTarget() != value2) {
            this.remove(bindingResultKey);
        }
    }
}

