/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.method;

import java.lang.reflect.Method;
import java.util.List;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.validation.method.DefaultMethodValidationResult;
import org.springframework.validation.method.EmptyMethodValidationResult;
import org.springframework.validation.method.ParameterErrors;
import org.springframework.validation.method.ParameterValidationResult;

public interface MethodValidationResult {
    public Object getTarget();

    public Method getMethod();

    public boolean isForReturnValue();

    default public boolean hasErrors() {
        return !this.getAllValidationResults().isEmpty();
    }

    default public List<? extends MessageSourceResolvable> getAllErrors() {
        return this.getAllValidationResults().stream().flatMap(result2 -> result2.getResolvableErrors().stream()).toList();
    }

    public List<ParameterValidationResult> getAllValidationResults();

    default public List<ParameterValidationResult> getValueResults() {
        return this.getAllValidationResults().stream().filter(result2 -> !(result2 instanceof ParameterErrors)).toList();
    }

    default public List<ParameterErrors> getBeanResults() {
        return this.getAllValidationResults().stream().filter(result2 -> result2 instanceof ParameterErrors).map(result2 -> (ParameterErrors)result2).toList();
    }

    public static MethodValidationResult create(Object target2, Method method2, List<ParameterValidationResult> results) {
        return new DefaultMethodValidationResult(target2, method2, results);
    }

    public static MethodValidationResult emptyResult() {
        return new EmptyMethodValidationResult();
    }
}

