/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.method;

import java.lang.reflect.Method;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.validation.method.MethodValidationResult;
import org.springframework.validation.method.ParameterValidationResult;

final class DefaultMethodValidationResult
implements MethodValidationResult {
    private final Object target;
    private final Method method;
    private final List<ParameterValidationResult> allValidationResults;
    private final boolean forReturnValue;

    DefaultMethodValidationResult(Object target2, Method method2, List<ParameterValidationResult> results) {
        Assert.notEmpty(results, "'results' is required and must not be empty");
        Assert.notNull(target2, "'target' is required");
        Assert.notNull((Object)method2, "Method is required");
        this.target = target2;
        this.method = method2;
        this.allValidationResults = results;
        this.forReturnValue = results.get(0).getMethodParameter().getParameterIndex() == -1;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public boolean isForReturnValue() {
        return this.forReturnValue;
    }

    @Override
    public List<ParameterValidationResult> getAllValidationResults() {
        return this.allValidationResults;
    }

    public String toString() {
        return this.getAllErrors().size() + " validation errors for " + (this.isForReturnValue() ? "return value" : "arguments") + " of " + this.method.toGenericString();
    }
}

