/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.executable.ExecutableValidator;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.ConstraintDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.SmartValidator;

public class SpringValidatorAdapter
implements SmartValidator,
Validator {
    private static final Set<String> internalAnnotationAttributes = Set.of("message", "groups", "payload");
    @Nullable
    private Validator targetValidator;

    public SpringValidatorAdapter(Validator targetValidator) {
        Assert.notNull((Object)targetValidator, "Target Validator must not be null");
        this.targetValidator = targetValidator;
    }

    SpringValidatorAdapter() {
    }

    void setTargetValidator(Validator targetValidator) {
        this.targetValidator = targetValidator;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return this.targetValidator != null;
    }

    @Override
    public void validate(Object target2, Errors errors) {
        if (this.targetValidator != null) {
            this.processConstraintViolations(this.targetValidator.validate(target2, new Class[0]), errors);
        }
    }

    @Override
    public void validate(Object target2, Errors errors, Object ... validationHints) {
        if (this.targetValidator != null) {
            this.processConstraintViolations(this.targetValidator.validate(target2, (Class[])this.asValidationGroups(validationHints)), errors);
        }
    }

    @Override
    public void validateValue(Class<?> targetType, String fieldName, @Nullable Object value2, Errors errors, Object ... validationHints) {
        if (this.targetValidator != null) {
            this.processConstraintViolations(this.targetValidator.validateValue(targetType, fieldName, value2, (Class[])this.asValidationGroups(validationHints)), errors);
        }
    }

    private Class<?>[] asValidationGroups(Object ... validationHints) {
        LinkedHashSet groups2 = new LinkedHashSet(4);
        for (Object hint : validationHints) {
            if (!(hint instanceof Class)) continue;
            Class clazz = (Class)hint;
            groups2.add(clazz);
        }
        return ClassUtils.toClassArray(groups2);
    }

    protected void processConstraintViolations(Set<ConstraintViolation<Object>> violations, Errors errors) {
        for (ConstraintViolation<Object> violation : violations) {
            String field = this.determineField(violation);
            FieldError fieldError = errors.getFieldError(field);
            if (fieldError != null && fieldError.isBindingFailure()) continue;
            try {
                ConstraintDescriptor cd = violation.getConstraintDescriptor();
                String errorCode = this.determineErrorCode(cd);
                Object[] errorArgs = this.getArgumentsForConstraint(errors.getObjectName(), field, cd);
                if (errors instanceof BindingResult) {
                    BindingResult bindingResult = (BindingResult)errors;
                    String nestedField = bindingResult.getNestedPath() + field;
                    if (nestedField.isEmpty()) {
                        String[] errorCodes = bindingResult.resolveMessageCodes(errorCode);
                        ViolationObjectError error2 = new ViolationObjectError(errors.getObjectName(), errorCodes, errorArgs, violation, this);
                        bindingResult.addError(error2);
                        continue;
                    }
                    Object rejectedValue = this.getRejectedValue(field, violation, bindingResult);
                    String[] errorCodes = bindingResult.resolveMessageCodes(errorCode, field);
                    ViolationFieldError error3 = new ViolationFieldError(errors.getObjectName(), nestedField, rejectedValue, errorCodes, errorArgs, violation, this);
                    bindingResult.addError(error3);
                    continue;
                }
                errors.rejectValue(field, errorCode, errorArgs, violation.getMessage());
            }
            catch (NotReadablePropertyException ex) {
                throw new IllegalStateException("JSR-303 validated property '" + field + "' does not have a corresponding accessor for Spring data binding - check your DataBinder's configuration (bean property versus direct field access)", ex);
            }
        }
    }

    protected String determineField(ConstraintViolation<Object> violation) {
        Path path2 = violation.getPropertyPath();
        StringBuilder sb = new StringBuilder();
        boolean first2 = true;
        for (Path.Node node : path2) {
            String name2;
            if (node.isInIterable() && !first2) {
                sb.append('[');
                Object index2 = node.getIndex();
                if (index2 == null) {
                    index2 = node.getKey();
                }
                if (index2 != null) {
                    sb.append(index2);
                }
                sb.append(']');
            }
            if ((name2 = node.getName()) == null || node.getKind() != ElementKind.PROPERTY || name2.startsWith("<")) continue;
            if (!first2) {
                sb.append('.');
            }
            first2 = false;
            sb.append(name2);
        }
        return sb.toString();
    }

    protected String determineErrorCode(ConstraintDescriptor<?> descriptor) {
        return descriptor.getAnnotation().annotationType().getSimpleName();
    }

    protected Object[] getArgumentsForConstraint(String objectName, String field, ConstraintDescriptor<?> descriptor) {
        ArrayList<MessageSourceResolvable> arguments = new ArrayList<MessageSourceResolvable>();
        arguments.add(this.getResolvableField(objectName, field));
        TreeMap attributesToExpose = new TreeMap();
        descriptor.getAttributes().forEach((attributeName, attributeValue) -> {
            if (!internalAnnotationAttributes.contains(attributeName)) {
                if (attributeValue instanceof String) {
                    String str = (String)attributeValue;
                    attributeValue = new ResolvableAttribute(str);
                }
                attributesToExpose.put(attributeName, attributeValue);
            }
        });
        arguments.addAll(attributesToExpose.values());
        return arguments.toArray();
    }

    protected MessageSourceResolvable getResolvableField(String objectName, String field) {
        String[] stringArray;
        if (StringUtils.hasText(field)) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = objectName + "." + field;
            stringArray = stringArray2;
            stringArray2[1] = field;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = objectName;
        }
        String[] codes = stringArray;
        return new DefaultMessageSourceResolvable(codes, field);
    }

    @Nullable
    protected Object getRejectedValue(String field, ConstraintViolation<Object> violation, BindingResult bindingResult) {
        Object invalidValue = violation.getInvalidValue();
        if (!field.isEmpty() && !field.contains("[]") && (invalidValue == violation.getLeafBean() || field.contains("[") || field.contains("."))) {
            try {
                invalidValue = bindingResult.getRawFieldValue(field);
            }
            catch (InvalidPropertyException invalidPropertyException) {
                // empty catch block
            }
        }
        return invalidValue;
    }

    protected boolean requiresMessageFormat(ConstraintViolation<?> violation) {
        return SpringValidatorAdapter.containsSpringStylePlaceholder(violation.getMessage());
    }

    private static boolean containsSpringStylePlaceholder(@Nullable String message2) {
        return message2 != null && message2.contains("{0}");
    }

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups2) {
        Assert.state(this.targetValidator != null, "No target Validator set");
        return this.targetValidator.validate(object, (Class[])groups2);
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups2) {
        Assert.state(this.targetValidator != null, "No target Validator set");
        return this.targetValidator.validateProperty(object, propertyName, (Class[])groups2);
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value2, Class<?> ... groups2) {
        Assert.state(this.targetValidator != null, "No target Validator set");
        return this.targetValidator.validateValue(beanType, propertyName, value2, (Class[])groups2);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        Assert.state(this.targetValidator != null, "No target Validator set");
        return this.targetValidator.getConstraintsForClass(clazz);
    }

    @Override
    public <T> T unwrap(@Nullable Class<T> type2) {
        Assert.state(this.targetValidator != null, "No target Validator set");
        try {
            return (T)(type2 != null ? this.targetValidator.unwrap(type2) : this.targetValidator);
        }
        catch (ValidationException ex) {
            if (Validator.class == type2) {
                return (T)this.targetValidator;
            }
            throw ex;
        }
    }

    public ExecutableValidator forExecutables() {
        Assert.state(this.targetValidator != null, "No target Validator set");
        return this.targetValidator.forExecutables();
    }

    private static class ViolationObjectError
    extends ObjectError
    implements Serializable {
        @Nullable
        private transient SpringValidatorAdapter adapter;
        @Nullable
        private transient ConstraintViolation<?> violation;

        public ViolationObjectError(String objectName, String[] codes, Object[] arguments, ConstraintViolation<?> violation, SpringValidatorAdapter adapter) {
            super(objectName, codes, arguments, violation.getMessage());
            this.adapter = adapter;
            this.violation = violation;
            this.wrap(violation);
        }

        @Override
        public boolean shouldRenderDefaultMessage() {
            return this.adapter != null && this.violation != null ? this.adapter.requiresMessageFormat(this.violation) : SpringValidatorAdapter.containsSpringStylePlaceholder(this.getDefaultMessage());
        }
    }

    private static class ViolationFieldError
    extends FieldError
    implements Serializable {
        @Nullable
        private transient SpringValidatorAdapter adapter;
        @Nullable
        private transient ConstraintViolation<?> violation;

        public ViolationFieldError(String objectName, String field, @Nullable Object rejectedValue, String[] codes, Object[] arguments, ConstraintViolation<?> violation, SpringValidatorAdapter adapter) {
            super(objectName, field, rejectedValue, false, codes, arguments, violation.getMessage());
            this.adapter = adapter;
            this.violation = violation;
            this.wrap(violation);
        }

        @Override
        public boolean shouldRenderDefaultMessage() {
            return this.adapter != null && this.violation != null ? this.adapter.requiresMessageFormat(this.violation) : SpringValidatorAdapter.containsSpringStylePlaceholder(this.getDefaultMessage());
        }
    }

    private static class ResolvableAttribute
    implements MessageSourceResolvable,
    Serializable {
        private final String resolvableString;

        public ResolvableAttribute(String resolvableString) {
            this.resolvableString = resolvableString;
        }

        @Override
        public String[] getCodes() {
            return new String[]{this.resolvableString};
        }

        @Override
        @Nullable
        public Object[] getArguments() {
            return null;
        }

        @Override
        public String getDefaultMessage() {
            return this.resolvableString;
        }

        public String toString() {
            return this.resolvableString;
        }
    }
}

