/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Valid;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.validation.beanvalidation.MethodValidationAdapter;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;
import org.springframework.validation.method.MethodValidationException;
import org.springframework.validation.method.MethodValidationResult;
import org.springframework.validation.method.ParameterErrors;
import org.springframework.validation.method.ParameterValidationResult;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MethodValidationInterceptor
implements MethodInterceptor {
    private static final boolean reactorPresent = ClassUtils.isPresent("reactor.core.publisher.Mono", MethodValidationInterceptor.class.getClassLoader());
    private final MethodValidationAdapter validationAdapter;
    private final boolean adaptViolations;

    public MethodValidationInterceptor() {
        this(new MethodValidationAdapter(), false);
    }

    public MethodValidationInterceptor(ValidatorFactory validatorFactory) {
        this(new MethodValidationAdapter(validatorFactory), false);
    }

    public MethodValidationInterceptor(Validator validator) {
        this(new MethodValidationAdapter(validator), false);
    }

    public MethodValidationInterceptor(Supplier<Validator> validator) {
        this(validator, false);
    }

    public MethodValidationInterceptor(Supplier<Validator> validator, boolean adaptViolations) {
        this(new MethodValidationAdapter(validator), adaptViolations);
    }

    private MethodValidationInterceptor(MethodValidationAdapter validationAdapter, boolean adaptViolations) {
        this.validationAdapter = validationAdapter;
        this.adaptViolations = adaptViolations;
    }

    @Override
    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Set<ConstraintViolation<Object>> violations;
        if (this.isFactoryBeanMetadataMethod(invocation.getMethod())) {
            return invocation.proceed();
        }
        Object target2 = MethodValidationInterceptor.getTarget(invocation);
        Method method2 = invocation.getMethod();
        Object[] arguments = invocation.getArguments();
        Class<?>[] groups2 = this.determineValidationGroups(invocation);
        if (reactorPresent) {
            arguments = ReactorValidationHelper.insertAsyncValidation(this.validationAdapter.getSpringValidatorAdapter(), this.adaptViolations, target2, method2, arguments);
        }
        if (this.adaptViolations) {
            this.validationAdapter.applyArgumentValidation(target2, method2, null, arguments, groups2);
        } else {
            violations = this.validationAdapter.invokeValidatorForArguments(target2, method2, arguments, groups2);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        Object returnValue = invocation.proceed();
        if (this.adaptViolations) {
            this.validationAdapter.applyReturnValueValidation(target2, method2, null, returnValue, groups2);
        } else {
            violations = this.validationAdapter.invokeValidatorForReturnValue(target2, method2, returnValue, groups2);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        return returnValue;
    }

    private static Object getTarget(MethodInvocation invocation) {
        Object target2 = invocation.getThis();
        if (target2 == null && invocation instanceof ProxyMethodInvocation) {
            ProxyMethodInvocation methodInvocation = (ProxyMethodInvocation)invocation;
            target2 = methodInvocation.getProxy();
        }
        Assert.state(target2 != null, "Target must not be null");
        return target2;
    }

    private boolean isFactoryBeanMetadataMethod(Method method2) {
        Class<?> clazz = method2.getDeclaringClass();
        if (clazz.isInterface()) {
            return (clazz == FactoryBean.class || clazz == SmartFactoryBean.class) && !method2.getName().equals("getObject");
        }
        Class factoryBeanType = null;
        if (SmartFactoryBean.class.isAssignableFrom(clazz)) {
            factoryBeanType = SmartFactoryBean.class;
        } else if (FactoryBean.class.isAssignableFrom(clazz)) {
            factoryBeanType = FactoryBean.class;
        }
        return factoryBeanType != null && !method2.getName().equals("getObject") && ClassUtils.hasMethod(factoryBeanType, method2);
    }

    protected Class<?>[] determineValidationGroups(MethodInvocation invocation) {
        Object target2 = MethodValidationInterceptor.getTarget(invocation);
        return this.validationAdapter.determineValidationGroups(target2, invocation.getMethod());
    }

    private static final class ReactorValidationHelper {
        private static final ReactiveAdapterRegistry reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();

        private ReactorValidationHelper() {
        }

        static Object[] insertAsyncValidation(Supplier<SpringValidatorAdapter> validatorAdapterSupplier, boolean adaptViolations, Object target2, Method method2, Object[] arguments) {
            for (int i2 = 0; i2 < method2.getParameterCount(); ++i2) {
                Class[] groups2;
                Class<?> parameterType;
                ReactiveAdapter reactiveAdapter;
                if (arguments[i2] == null || (reactiveAdapter = reactiveAdapterRegistry.getAdapter(parameterType = method2.getParameterTypes()[i2])) == null || reactiveAdapter.isNoValue() || (groups2 = ReactorValidationHelper.determineValidationGroups(method2.getParameters()[i2])) == null) continue;
                SpringValidatorAdapter validatorAdapter = validatorAdapterSupplier.get();
                MethodParameter param = new MethodParameter(method2, i2);
                arguments[i2] = reactiveAdapter.isMultiValue() ? Flux.from(reactiveAdapter.toPublisher(arguments[i2])).doOnNext(value2 -> ReactorValidationHelper.validate(validatorAdapter, adaptViolations, target2, method2, param, value2, groups2)) : Mono.from(reactiveAdapter.toPublisher(arguments[i2])).doOnNext(value2 -> ReactorValidationHelper.validate(validatorAdapter, adaptViolations, target2, method2, param, value2, groups2));
            }
            return arguments;
        }

        @Nullable
        private static Class<?>[] determineValidationGroups(Parameter parameter) {
            Validated validated = AnnotationUtils.findAnnotation(parameter, Validated.class);
            if (validated != null) {
                return validated.value();
            }
            Valid valid = AnnotationUtils.findAnnotation(parameter, Valid.class);
            if (valid != null) {
                return new Class[0];
            }
            return null;
        }

        private static <T> void validate(SpringValidatorAdapter validatorAdapter, boolean adaptViolations, Object target2, Method method2, MethodParameter parameter, Object argument, Class<?>[] groups2) {
            if (adaptViolations) {
                BeanPropertyBindingResult errors = new BeanPropertyBindingResult(argument, argument.getClass().getSimpleName());
                validatorAdapter.validate(argument, errors);
                if (errors.hasErrors()) {
                    ParameterErrors paramErrors = new ParameterErrors(parameter, argument, errors, null, null, null);
                    List<ParameterValidationResult> results = Collections.singletonList(paramErrors);
                    throw new MethodValidationException(MethodValidationResult.create(target2, method2, results));
                }
            } else {
                Set<ConstraintViolation<Object>> violations = validatorAdapter.validate(argument, groups2);
                if (!violations.isEmpty()) {
                    throw new ConstraintViolationException(violations);
                }
            }
        }
    }
}

