/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;

public abstract class BindingResultUtils {
    @Nullable
    public static BindingResult getBindingResult(Map<?, ?> model, String name2) {
        Assert.notNull(model, "Model map must not be null");
        Assert.notNull((Object)name2, "Name must not be null");
        Object attr2 = model.get(BindingResult.MODEL_KEY_PREFIX + name2);
        if (attr2 == null) {
            return null;
        }
        if (attr2 instanceof BindingResult) {
            BindingResult bindingResult = (BindingResult)attr2;
            return bindingResult;
        }
        throw new IllegalStateException("BindingResult attribute is not of type BindingResult: " + attr2);
    }

    public static BindingResult getRequiredBindingResult(Map<?, ?> model, String name2) {
        BindingResult bindingResult = BindingResultUtils.getBindingResult(model, name2);
        if (bindingResult == null) {
            throw new IllegalStateException("No BindingResult attribute found for name '" + name2 + "'- have you exposed the correct model?");
        }
        return bindingResult;
    }
}

