/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.springframework.util.xml.AbstractStaxHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class StaxStreamHandler
extends AbstractStaxHandler {
    private final XMLStreamWriter streamWriter;

    public StaxStreamHandler(XMLStreamWriter streamWriter) {
        this.streamWriter = streamWriter;
    }

    @Override
    protected void startDocumentInternal() throws XMLStreamException {
        this.streamWriter.writeStartDocument();
    }

    @Override
    protected void endDocumentInternal() throws XMLStreamException {
        this.streamWriter.writeEndDocument();
    }

    @Override
    protected void startElementInternal(QName name2, Attributes attributes, Map<String, String> namespaceMapping) throws XMLStreamException {
        this.streamWriter.writeStartElement(name2.getPrefix(), name2.getLocalPart(), name2.getNamespaceURI());
        for (Map.Entry<String, String> entry : namespaceMapping.entrySet()) {
            String prefix = entry.getKey();
            String namespaceUri = entry.getValue();
            this.streamWriter.writeNamespace(prefix, namespaceUri);
            if ("".equals(prefix)) {
                this.streamWriter.setDefaultNamespace(namespaceUri);
                continue;
            }
            this.streamWriter.setPrefix(prefix, namespaceUri);
        }
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            QName attrName = this.toQName(attributes.getURI(i2), attributes.getQName(i2));
            if (this.isNamespaceDeclaration(attrName)) continue;
            this.streamWriter.writeAttribute(attrName.getPrefix(), attrName.getNamespaceURI(), attrName.getLocalPart(), attributes.getValue(i2));
        }
    }

    @Override
    protected void endElementInternal(QName name2, Map<String, String> namespaceMapping) throws XMLStreamException {
        this.streamWriter.writeEndElement();
    }

    @Override
    protected void charactersInternal(String data2) throws XMLStreamException {
        this.streamWriter.writeCharacters(data2);
    }

    @Override
    protected void cDataInternal(String data2) throws XMLStreamException {
        this.streamWriter.writeCData(data2);
    }

    @Override
    protected void ignorableWhitespaceInternal(String data2) throws XMLStreamException {
        this.streamWriter.writeCharacters(data2);
    }

    @Override
    protected void processingInstructionInternal(String target2, String data2) throws XMLStreamException {
        this.streamWriter.writeProcessingInstruction(target2, data2);
    }

    @Override
    protected void dtdInternal(String dtd) throws XMLStreamException {
        this.streamWriter.writeDTD(dtd);
    }

    @Override
    protected void commentInternal(String comment2) throws XMLStreamException {
        this.streamWriter.writeComment(comment2);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startEntity(String name2) throws SAXException {
    }

    @Override
    public void endEntity(String name2) throws SAXException {
    }

    @Override
    protected void skippedEntityInternal(String name2) throws XMLStreamException {
    }
}

