/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.NotationDeclaration;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.AbstractStaxXMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.AttributesImpl;

class StaxEventXMLReader
extends AbstractStaxXMLReader {
    private static final String DEFAULT_XML_VERSION = "1.0";
    private final XMLEventReader reader;
    private String xmlVersion = "1.0";
    @Nullable
    private String encoding;

    StaxEventXMLReader(XMLEventReader reader) {
        try {
            XMLEvent event2 = reader.peek();
            if (event2 != null && !event2.isStartDocument() && !event2.isStartElement()) {
                throw new IllegalStateException("XMLEventReader not at start of document or element");
            }
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException("Could not read first element: " + ex.getMessage());
        }
        this.reader = reader;
    }

    @Override
    protected void parseInternal() throws SAXException, XMLStreamException {
        boolean documentStarted = false;
        boolean documentEnded = false;
        int elementDepth = 0;
        while (this.reader.hasNext() && elementDepth >= 0) {
            XMLEvent event2 = this.reader.nextEvent();
            if (!(event2.isStartDocument() || event2.isEndDocument() || documentStarted)) {
                this.handleStartDocument(event2);
                documentStarted = true;
            }
            switch (event2.getEventType()) {
                case 7: {
                    this.handleStartDocument(event2);
                    documentStarted = true;
                    break;
                }
                case 1: {
                    ++elementDepth;
                    this.handleStartElement(event2.asStartElement());
                    break;
                }
                case 2: {
                    if (--elementDepth < 0) break;
                    this.handleEndElement(event2.asEndElement());
                    break;
                }
                case 3: {
                    this.handleProcessingInstruction((ProcessingInstruction)event2);
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    this.handleCharacters(event2.asCharacters());
                    break;
                }
                case 8: {
                    this.handleEndDocument();
                    documentEnded = true;
                    break;
                }
                case 14: {
                    this.handleNotationDeclaration((NotationDeclaration)event2);
                    break;
                }
                case 15: {
                    this.handleEntityDeclaration((EntityDeclaration)event2);
                    break;
                }
                case 5: {
                    this.handleComment((Comment)event2);
                    break;
                }
                case 11: {
                    this.handleDtd((DTD)event2);
                    break;
                }
                case 9: {
                    this.handleEntityReference((EntityReference)event2);
                }
            }
        }
        if (documentStarted && !documentEnded) {
            this.handleEndDocument();
        }
    }

    private void handleStartDocument(XMLEvent event2) throws SAXException {
        ContentHandler contentHandler;
        if (event2.isStartDocument()) {
            StartDocument startDocument = (StartDocument)event2;
            String xmlVersion = startDocument.getVersion();
            if (StringUtils.hasLength(xmlVersion)) {
                this.xmlVersion = xmlVersion;
            }
            if (startDocument.encodingSet()) {
                this.encoding = startDocument.getCharacterEncodingScheme();
            }
        }
        if ((contentHandler = this.getContentHandler()) != null) {
            final Location location = event2.getLocation();
            contentHandler.setDocumentLocator(new Locator2(){

                @Override
                public int getColumnNumber() {
                    return location != null ? location.getColumnNumber() : -1;
                }

                @Override
                public int getLineNumber() {
                    return location != null ? location.getLineNumber() : -1;
                }

                @Override
                @Nullable
                public String getPublicId() {
                    return location != null ? location.getPublicId() : null;
                }

                @Override
                @Nullable
                public String getSystemId() {
                    return location != null ? location.getSystemId() : null;
                }

                @Override
                public String getXMLVersion() {
                    return StaxEventXMLReader.this.xmlVersion;
                }

                @Override
                @Nullable
                public String getEncoding() {
                    return StaxEventXMLReader.this.encoding;
                }
            });
            contentHandler.startDocument();
        }
    }

    private void handleStartElement(StartElement startElement) throws SAXException {
        if (this.getContentHandler() != null) {
            QName qName = startElement.getName();
            if (this.hasNamespacesFeature()) {
                Iterator<Attribute> i2 = startElement.getNamespaces();
                while (i2.hasNext()) {
                    Namespace namespace = i2.next();
                    this.startPrefixMapping(namespace.getPrefix(), namespace.getNamespaceURI());
                }
                i2 = startElement.getAttributes();
                while (i2.hasNext()) {
                    Attribute attribute = i2.next();
                    QName attributeName = attribute.getName();
                    this.startPrefixMapping(attributeName.getPrefix(), attributeName.getNamespaceURI());
                }
                this.getContentHandler().startElement(qName.getNamespaceURI(), qName.getLocalPart(), this.toQualifiedName(qName), this.getAttributes(startElement));
            } else {
                this.getContentHandler().startElement("", "", this.toQualifiedName(qName), this.getAttributes(startElement));
            }
        }
    }

    private void handleCharacters(Characters characters) throws SAXException {
        char[] data2 = characters.getData().toCharArray();
        if (this.getContentHandler() != null && characters.isIgnorableWhiteSpace()) {
            this.getContentHandler().ignorableWhitespace(data2, 0, data2.length);
            return;
        }
        if (characters.isCData() && this.getLexicalHandler() != null) {
            this.getLexicalHandler().startCDATA();
        }
        if (this.getContentHandler() != null) {
            this.getContentHandler().characters(data2, 0, data2.length);
        }
        if (characters.isCData() && this.getLexicalHandler() != null) {
            this.getLexicalHandler().endCDATA();
        }
    }

    private void handleEndElement(EndElement endElement) throws SAXException {
        if (this.getContentHandler() != null) {
            QName qName = endElement.getName();
            if (this.hasNamespacesFeature()) {
                this.getContentHandler().endElement(qName.getNamespaceURI(), qName.getLocalPart(), this.toQualifiedName(qName));
                Iterator<Namespace> i2 = endElement.getNamespaces();
                while (i2.hasNext()) {
                    Namespace namespace = i2.next();
                    this.endPrefixMapping(namespace.getPrefix());
                }
            } else {
                this.getContentHandler().endElement("", "", this.toQualifiedName(qName));
            }
        }
    }

    private void handleEndDocument() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().endDocument();
        }
    }

    private void handleNotationDeclaration(NotationDeclaration declaration) throws SAXException {
        if (this.getDTDHandler() != null) {
            this.getDTDHandler().notationDecl(declaration.getName(), declaration.getPublicId(), declaration.getSystemId());
        }
    }

    private void handleEntityDeclaration(EntityDeclaration entityDeclaration) throws SAXException {
        if (this.getDTDHandler() != null) {
            this.getDTDHandler().unparsedEntityDecl(entityDeclaration.getName(), entityDeclaration.getPublicId(), entityDeclaration.getSystemId(), entityDeclaration.getNotationName());
        }
    }

    private void handleProcessingInstruction(ProcessingInstruction pi) throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().processingInstruction(pi.getTarget(), pi.getData());
        }
    }

    private void handleComment(Comment comment2) throws SAXException {
        if (this.getLexicalHandler() != null) {
            char[] ch = comment2.getText().toCharArray();
            this.getLexicalHandler().comment(ch, 0, ch.length);
        }
    }

    private void handleDtd(DTD dtd) throws SAXException {
        if (this.getLexicalHandler() != null) {
            Location location = dtd.getLocation();
            this.getLexicalHandler().startDTD(null, location.getPublicId(), location.getSystemId());
        }
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().endDTD();
        }
    }

    private void handleEntityReference(EntityReference reference2) throws SAXException {
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().startEntity(reference2.getName());
        }
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().endEntity(reference2.getName());
        }
    }

    private Attributes getAttributes(StartElement event2) {
        AttributesImpl attributes = new AttributesImpl();
        Iterator<Attribute> i2 = event2.getAttributes();
        while (i2.hasNext()) {
            String type2;
            Attribute attribute = i2.next();
            QName qName = attribute.getName();
            String namespace = qName.getNamespaceURI();
            if (namespace == null || !this.hasNamespacesFeature()) {
                namespace = "";
            }
            if ((type2 = attribute.getDTDType()) == null) {
                type2 = "CDATA";
            }
            attributes.addAttribute(namespace, qName.getLocalPart(), this.toQualifiedName(qName), type2, attribute.getValue());
        }
        if (this.hasNamespacePrefixesFeature()) {
            i2 = event2.getNamespaces();
            while (i2.hasNext()) {
                Namespace namespace = (Namespace)i2.next();
                String prefix = namespace.getPrefix();
                String namespaceUri = namespace.getNamespaceURI();
                Object qName = StringUtils.hasLength(prefix) ? "xmlns:" + prefix : "xmlns";
                attributes.addAttribute("", "", (String)qName, "CDATA", namespaceUri);
            }
        }
        return attributes;
    }
}

