/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.springframework.util.Assert;

public abstract class FutureUtils {
    public static <T> CompletableFuture<T> callAsync(Callable<T> callable) {
        Assert.notNull(callable, "Callable must not be null");
        CompletableFuture<T> result2 = new CompletableFuture<T>();
        return result2.completeAsync(FutureUtils.toSupplier(callable, result2));
    }

    public static <T> CompletableFuture<T> callAsync(Callable<T> callable, Executor executor) {
        Assert.notNull(callable, "Callable must not be null");
        Assert.notNull((Object)executor, "Executor must not be null");
        CompletableFuture<T> result2 = new CompletableFuture<T>();
        return result2.completeAsync(FutureUtils.toSupplier(callable, result2), executor);
    }

    private static <T> Supplier<T> toSupplier(Callable<T> callable, CompletableFuture<T> result2) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Exception ex) {
                result2.completeExceptionally(ex instanceof CompletionException ? ex : new CompletionException(ex));
                return null;
            }
        };
    }
}

