/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public abstract class ReflectionUtils {
    public static final MethodFilter USER_DECLARED_METHODS = method2 -> !method2.isBridge() && !method2.isSynthetic() && method2.getDeclaringClass() != Object.class;
    public static final FieldFilter COPYABLE_FIELDS = field -> !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
    private static final String CGLIB_RENAMED_METHOD_PREFIX = "CGLIB$";
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Map<Class<?>, Method[]> declaredMethodsCache = new ConcurrentReferenceHashMap(256);
    private static final Map<Class<?>, Field[]> declaredFieldsCache = new ConcurrentReferenceHashMap(256);

    public static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method or field: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)ex;
            ReflectionUtils.handleInvocationTargetException(invocationTargetException);
        }
        if (ex instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)ex;
            throw runtimeException;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void handleInvocationTargetException(InvocationTargetException ex) {
        ReflectionUtils.rethrowRuntimeException(ex.getTargetException());
    }

    public static void rethrowRuntimeException(@Nullable Throwable ex) {
        if (ex instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)ex;
            throw runtimeException;
        }
        if (ex instanceof Error) {
            Error error2 = (Error)ex;
            throw error2;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void rethrowException(@Nullable Throwable throwable) throws Exception {
        if (throwable instanceof Exception) {
            Exception exception2 = (Exception)throwable;
            throw exception2;
        }
        if (throwable instanceof Error) {
            Error error2 = (Error)throwable;
            throw error2;
        }
        throw new UndeclaredThrowableException(throwable);
    }

    public static <T> Constructor<T> accessibleConstructor(Class<T> clazz, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Constructor<T> ctor = clazz.getDeclaredConstructor(parameterTypes);
        ReflectionUtils.makeAccessible(ctor);
        return ctor;
    }

    public static void makeAccessible(Constructor<?> ctor) {
        if (!(Modifier.isPublic(ctor.getModifiers()) && Modifier.isPublic(ctor.getDeclaringClass().getModifiers()) || ctor.isAccessible())) {
            ctor.setAccessible(true);
        }
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String name2) {
        return ReflectionUtils.findMethod(clazz, name2, EMPTY_CLASS_ARRAY);
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String name2, Class<?> ... paramTypes) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)name2, "Method name must not be null");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods2;
            for (Method method2 : methods2 = searchType.isInterface() ? searchType.getMethods() : ReflectionUtils.getDeclaredMethods(searchType, false)) {
                if (!name2.equals(method2.getName()) || paramTypes != null && !ReflectionUtils.hasSameParams(method2, paramTypes)) continue;
                return method2;
            }
        }
        return null;
    }

    private static boolean hasSameParams(Method method2, Class<?>[] paramTypes) {
        return paramTypes.length == method2.getParameterCount() && Arrays.equals(paramTypes, method2.getParameterTypes());
    }

    @Nullable
    public static Object invokeMethod(Method method2, @Nullable Object target2) {
        return ReflectionUtils.invokeMethod(method2, target2, EMPTY_OBJECT_ARRAY);
    }

    @Nullable
    public static Object invokeMethod(Method method2, @Nullable Object target2, Object ... args2) {
        try {
            return method2.invoke(target2, args2);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static boolean declaresException(Method method2, Class<?> exceptionType) {
        Class<?>[] declaredExceptions;
        Assert.notNull((Object)method2, "Method must not be null");
        for (Class<?> declaredException : declaredExceptions = method2.getExceptionTypes()) {
            if (!declaredException.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static void doWithLocalMethods(Class<?> clazz, MethodCallback mc) {
        Method[] methods2;
        for (Method method2 : methods2 = ReflectionUtils.getDeclaredMethods(clazz, false)) {
            try {
                mc.doWith(method2);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access method '" + method2.getName() + "': " + ex);
            }
        }
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc) {
        ReflectionUtils.doWithMethods(clazz, mc, null);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc, @Nullable MethodFilter mf) {
        if (mf == USER_DECLARED_METHODS && clazz == Object.class) {
            return;
        }
        Method[] methods2 = ReflectionUtils.getDeclaredMethods(clazz, false);
        for (Method method2 : methods2) {
            if (mf != null && !mf.matches(method2)) continue;
            try {
                mc.doWith(method2);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access method '" + method2.getName() + "': " + ex);
            }
        }
        if (clazz.getSuperclass() != null && (mf != USER_DECLARED_METHODS || clazz.getSuperclass() != Object.class)) {
            ReflectionUtils.doWithMethods(clazz.getSuperclass(), mc, mf);
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                ReflectionUtils.doWithMethods(genericDeclaration, mc, mf);
            }
        }
    }

    public static Method[] getAllDeclaredMethods(Class<?> leafClass) {
        ArrayList methods2 = new ArrayList(20);
        ReflectionUtils.doWithMethods(leafClass, methods2::add);
        return methods2.toArray(EMPTY_METHOD_ARRAY);
    }

    public static Method[] getUniqueDeclaredMethods(Class<?> leafClass) {
        return ReflectionUtils.getUniqueDeclaredMethods(leafClass, null);
    }

    public static Method[] getUniqueDeclaredMethods(Class<?> leafClass, @Nullable MethodFilter mf) {
        ArrayList methods2 = new ArrayList(20);
        ReflectionUtils.doWithMethods(leafClass, method2 -> {
            boolean knownSignature = false;
            Method methodBeingOverriddenWithCovariantReturnType = null;
            for (Method existingMethod : methods2) {
                if (!method2.getName().equals(existingMethod.getName()) || method2.getParameterCount() != existingMethod.getParameterCount() || !Arrays.equals(method2.getParameterTypes(), existingMethod.getParameterTypes())) continue;
                if (existingMethod.getReturnType() != method2.getReturnType() && existingMethod.getReturnType().isAssignableFrom(method2.getReturnType())) {
                    methodBeingOverriddenWithCovariantReturnType = existingMethod;
                    break;
                }
                knownSignature = true;
                break;
            }
            if (methodBeingOverriddenWithCovariantReturnType != null) {
                methods2.remove(methodBeingOverriddenWithCovariantReturnType);
            }
            if (!knownSignature && !ReflectionUtils.isCglibRenamedMethod(method2)) {
                methods2.add(method2);
            }
        }, mf);
        return methods2.toArray(EMPTY_METHOD_ARRAY);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return ReflectionUtils.getDeclaredMethods(clazz, true);
    }

    private static Method[] getDeclaredMethods(Class<?> clazz, boolean defensive) {
        Assert.notNull(clazz, "Class must not be null");
        Method[] result2 = declaredMethodsCache.get(clazz);
        if (result2 == null) {
            try {
                Method[] declaredMethods = clazz.getDeclaredMethods();
                List<Method> defaultMethods = ReflectionUtils.findDefaultMethodsOnInterfaces(clazz);
                if (defaultMethods != null) {
                    result2 = new Method[declaredMethods.length + defaultMethods.size()];
                    System.arraycopy(declaredMethods, 0, result2, 0, declaredMethods.length);
                    int index2 = declaredMethods.length;
                    Iterator<Method> iterator = defaultMethods.iterator();
                    while (iterator.hasNext()) {
                        Method defaultMethod;
                        result2[index2] = defaultMethod = iterator.next();
                        ++index2;
                    }
                } else {
                    result2 = declaredMethods;
                }
                declaredMethodsCache.put(clazz, result2.length == 0 ? EMPTY_METHOD_ARRAY : result2);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", ex);
            }
        }
        return result2.length == 0 || !defensive ? result2 : (Method[])result2.clone();
    }

    @Nullable
    private static List<Method> findDefaultMethodsOnInterfaces(Class<?> clazz) {
        ArrayList<Method> result2 = null;
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method method2 : ifc.getMethods()) {
                if (!method2.isDefault()) continue;
                if (result2 == null) {
                    result2 = new ArrayList<Method>();
                }
                result2.add(method2);
            }
        }
        return result2;
    }

    public static boolean isEqualsMethod(@Nullable Method method2) {
        return method2 != null && method2.getParameterCount() == 1 && method2.getName().equals("equals") && method2.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(@Nullable Method method2) {
        return method2 != null && method2.getParameterCount() == 0 && method2.getName().equals("hashCode");
    }

    public static boolean isToStringMethod(@Nullable Method method2) {
        return method2 != null && method2.getParameterCount() == 0 && method2.getName().equals("toString");
    }

    public static boolean isObjectMethod(@Nullable Method method2) {
        return method2 != null && (method2.getDeclaringClass() == Object.class || ReflectionUtils.isEqualsMethod(method2) || ReflectionUtils.isHashCodeMethod(method2) || ReflectionUtils.isToStringMethod(method2));
    }

    public static boolean isCglibRenamedMethod(Method renamedMethod) {
        String name2 = renamedMethod.getName();
        if (name2.startsWith(CGLIB_RENAMED_METHOD_PREFIX)) {
            int i2;
            for (i2 = name2.length() - 1; i2 >= 0 && Character.isDigit(name2.charAt(i2)); --i2) {
            }
            return i2 > CGLIB_RENAMED_METHOD_PREFIX.length() && i2 < name2.length() - 1 && name2.charAt(i2) == '$';
        }
        return false;
    }

    public static void makeAccessible(Method method2) {
        if (!(Modifier.isPublic(method2.getModifiers()) && Modifier.isPublic(method2.getDeclaringClass().getModifiers()) || method2.isAccessible())) {
            method2.setAccessible(true);
        }
    }

    @Nullable
    public static Field findField(Class<?> clazz, String name2) {
        return ReflectionUtils.findField(clazz, name2, null);
    }

    @Nullable
    public static Field findField(Class<?> clazz, @Nullable String name2, @Nullable Class<?> type2) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.isTrue(name2 != null || type2 != null, "Either name or type of the field must be specified");
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields2;
            for (Field field : fields2 = ReflectionUtils.getDeclaredFields(searchType)) {
                if (name2 != null && !name2.equals(field.getName()) || type2 != null && !type2.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    @Nullable
    public static Field findFieldIgnoreCase(Class<?> clazz, String name2) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)name2, "Name must not be null");
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields2;
            for (Field field : fields2 = ReflectionUtils.getDeclaredFields(searchType)) {
                if (!name2.equalsIgnoreCase(field.getName())) continue;
                return field;
            }
        }
        return null;
    }

    public static void setField(Field field, @Nullable Object target2, @Nullable Object value2) {
        try {
            field.set(target2, value2);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
        }
    }

    @Nullable
    public static Object getField(Field field, @Nullable Object target2) {
        try {
            return field.get(target2);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static void doWithLocalFields(Class<?> clazz, FieldCallback fc) {
        for (Field field : ReflectionUtils.getDeclaredFields(clazz)) {
            try {
                fc.doWith(field);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access field '" + field.getName() + "': " + ex);
            }
        }
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc) {
        ReflectionUtils.doWithFields(clazz, fc, null);
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc, @Nullable FieldFilter ff) {
        Class<?> targetClass = clazz;
        do {
            Field[] fields2;
            for (Field field : fields2 = ReflectionUtils.getDeclaredFields(targetClass)) {
                if (ff != null && !ff.matches(field)) continue;
                try {
                    fc.doWith(field);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Not allowed to access field '" + field.getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    private static Field[] getDeclaredFields(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        Field[] result2 = declaredFieldsCache.get(clazz);
        if (result2 == null) {
            try {
                result2 = clazz.getDeclaredFields();
                declaredFieldsCache.put(clazz, result2.length == 0 ? EMPTY_FIELD_ARRAY : result2);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", ex);
            }
        }
        return result2;
    }

    public static void shallowCopyFieldState(Object src, Object dest) {
        Assert.notNull(src, "Source for field copy cannot be null");
        Assert.notNull(dest, "Destination for field copy cannot be null");
        if (!src.getClass().isAssignableFrom(dest.getClass())) {
            throw new IllegalArgumentException("Destination class [" + dest.getClass().getName() + "] must be same or subclass as source class [" + src.getClass().getName() + "]");
        }
        ReflectionUtils.doWithFields(src.getClass(), field -> {
            ReflectionUtils.makeAccessible(field);
            Object srcValue = field.get(src);
            field.set(dest, srcValue);
        }, COPYABLE_FIELDS);
    }

    public static boolean isPublicStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static void clearCache() {
        declaredMethodsCache.clear();
        declaredFieldsCache.clear();
    }

    @FunctionalInterface
    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }

    @FunctionalInterface
    public static interface MethodFilter {
        public boolean matches(Method var1);

        default public MethodFilter and(MethodFilter next2) {
            Assert.notNull((Object)next2, "Next MethodFilter must not be null");
            return method2 -> this.matches(method2) && next2.matches(method2);
        }
    }

    @FunctionalInterface
    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    @FunctionalInterface
    public static interface FieldFilter {
        public boolean matches(Field var1);

        default public FieldFilter and(FieldFilter next2) {
            Assert.notNull((Object)next2, "Next FieldFilter must not be null");
            return field -> this.matches(field) && next2.matches(field);
        }
    }
}

