/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

public class MultiValueMapAdapter<K, V>
implements MultiValueMap<K, V>,
Serializable {
    private final Map<K, List<V>> targetMap;

    public MultiValueMapAdapter(Map<K, List<V>> targetMap) {
        Assert.notNull(targetMap, "'targetMap' must not be null");
        this.targetMap = targetMap;
    }

    @Override
    @Nullable
    public V getFirst(K key2) {
        List<V> values2 = this.targetMap.get(key2);
        return !CollectionUtils.isEmpty(values2) ? (V)values2.get(0) : null;
    }

    @Override
    public void add(K key2, @Nullable V value2) {
        List values2 = this.targetMap.computeIfAbsent(key2, k -> new ArrayList(1));
        values2.add(value2);
    }

    @Override
    public void addAll(K key2, List<? extends V> values2) {
        List currentValues = this.targetMap.computeIfAbsent(key2, k -> new ArrayList(values2.size()));
        currentValues.addAll(values2);
    }

    @Override
    public void addAll(MultiValueMap<K, V> values2) {
        values2.forEach(this::addAll);
    }

    @Override
    public void set(K key2, @Nullable V value2) {
        ArrayList<V> values2 = new ArrayList<V>(1);
        values2.add(value2);
        this.targetMap.put(key2, values2);
    }

    @Override
    public void setAll(Map<K, V> values2) {
        values2.forEach(this::set);
    }

    @Override
    public Map<K, V> toSingleValueMap() {
        LinkedHashMap singleValueMap = CollectionUtils.newLinkedHashMap(this.targetMap.size());
        this.targetMap.forEach((? super K key2, ? super V values2) -> {
            if (!CollectionUtils.isEmpty(values2)) {
                singleValueMap.put(key2, values2.get(0));
            }
        });
        return singleValueMap;
    }

    @Override
    public int size() {
        return this.targetMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.targetMap.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.targetMap.containsValue(value2);
    }

    @Override
    @Nullable
    public List<V> get(Object key2) {
        return this.targetMap.get(key2);
    }

    @Override
    @Nullable
    public List<V> put(K key2, List<V> value2) {
        return this.targetMap.put(key2, value2);
    }

    @Override
    @Nullable
    public List<V> putIfAbsent(K key2, List<V> value2) {
        return this.targetMap.putIfAbsent(key2, value2);
    }

    @Override
    @Nullable
    public List<V> remove(Object key2) {
        return this.targetMap.remove(key2);
    }

    @Override
    public void putAll(Map<? extends K, ? extends List<V>> map2) {
        this.targetMap.putAll(map2);
    }

    @Override
    public void clear() {
        this.targetMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.targetMap.keySet();
    }

    @Override
    public Collection<List<V>> values() {
        return this.targetMap.values();
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.targetMap.entrySet();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super List<V>> action) {
        this.targetMap.forEach(action);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || this.targetMap.equals(other);
    }

    @Override
    public int hashCode() {
        return this.targetMap.hashCode();
    }

    public String toString() {
        return this.targetMap.toString();
    }
}

