/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.springframework.util.UpdateMessageDigestInputStream;

public abstract class DigestUtils {
    private static final String MD5_ALGORITHM_NAME = "MD5";
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] md5Digest(byte[] bytes2) {
        return DigestUtils.digest(MD5_ALGORITHM_NAME, bytes2);
    }

    public static byte[] md5Digest(InputStream inputStream) throws IOException {
        return DigestUtils.digest(MD5_ALGORITHM_NAME, inputStream);
    }

    public static String md5DigestAsHex(byte[] bytes2) {
        return DigestUtils.digestAsHexString(MD5_ALGORITHM_NAME, bytes2);
    }

    public static String md5DigestAsHex(InputStream inputStream) throws IOException {
        return DigestUtils.digestAsHexString(MD5_ALGORITHM_NAME, inputStream);
    }

    public static StringBuilder appendMd5DigestAsHex(byte[] bytes2, StringBuilder builder) {
        return DigestUtils.appendDigestAsHex(MD5_ALGORITHM_NAME, bytes2, builder);
    }

    public static StringBuilder appendMd5DigestAsHex(InputStream inputStream, StringBuilder builder) throws IOException {
        return DigestUtils.appendDigestAsHex(MD5_ALGORITHM_NAME, inputStream, builder);
    }

    private static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Could not find MessageDigest with algorithm \"" + algorithm + "\"", ex);
        }
    }

    private static byte[] digest(String algorithm, byte[] bytes2) {
        return DigestUtils.getDigest(algorithm).digest(bytes2);
    }

    private static byte[] digest(String algorithm, InputStream inputStream) throws IOException {
        int bytesRead;
        MessageDigest messageDigest = DigestUtils.getDigest(algorithm);
        if (inputStream instanceof UpdateMessageDigestInputStream) {
            UpdateMessageDigestInputStream digestInputStream = (UpdateMessageDigestInputStream)inputStream;
            digestInputStream.updateMessageDigest(messageDigest);
            return messageDigest.digest();
        }
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            messageDigest.update(buffer, 0, bytesRead);
        }
        return messageDigest.digest();
    }

    private static String digestAsHexString(String algorithm, byte[] bytes2) {
        char[] hexDigest = DigestUtils.digestAsHexChars(algorithm, bytes2);
        return new String(hexDigest);
    }

    private static String digestAsHexString(String algorithm, InputStream inputStream) throws IOException {
        char[] hexDigest = DigestUtils.digestAsHexChars(algorithm, inputStream);
        return new String(hexDigest);
    }

    private static StringBuilder appendDigestAsHex(String algorithm, byte[] bytes2, StringBuilder builder) {
        char[] hexDigest = DigestUtils.digestAsHexChars(algorithm, bytes2);
        return builder.append(hexDigest);
    }

    private static StringBuilder appendDigestAsHex(String algorithm, InputStream inputStream, StringBuilder builder) throws IOException {
        char[] hexDigest = DigestUtils.digestAsHexChars(algorithm, inputStream);
        return builder.append(hexDigest);
    }

    private static char[] digestAsHexChars(String algorithm, byte[] bytes2) {
        byte[] digest2 = DigestUtils.digest(algorithm, bytes2);
        return DigestUtils.encodeHex(digest2);
    }

    private static char[] digestAsHexChars(String algorithm, InputStream inputStream) throws IOException {
        byte[] digest2 = DigestUtils.digest(algorithm, inputStream);
        return DigestUtils.encodeHex(digest2);
    }

    private static char[] encodeHex(byte[] bytes2) {
        char[] chars2 = new char[32];
        for (int i2 = 0; i2 < chars2.length; i2 += 2) {
            byte b2 = bytes2[i2 / 2];
            chars2[i2] = HEX_CHARS[b2 >>> 4 & 0xF];
            chars2[i2 + 1] = HEX_CHARS[b2 & 0xF];
        }
        return chars2;
    }
}

