/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Closeable;
import java.io.Externalizable;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class ClassUtils {
    public static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[";
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char PATH_SEPARATOR = '/';
    private static final char NESTED_CLASS_SEPARATOR = '$';
    public static final String CGLIB_CLASS_SEPARATOR = "$$";
    public static final String CLASS_FILE_SUFFIX = ".class";
    private static final int NON_OVERRIDABLE_MODIFIER = 26;
    private static final int OVERRIDABLE_MODIFIER = 5;
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap = new IdentityHashMap(9);
    private static final Map<Class<?>, Class<?>> primitiveTypeToWrapperMap = new IdentityHashMap(9);
    private static final Map<String, Class<?>> primitiveTypeNameMap = new HashMap(32);
    private static final Map<String, Class<?>> commonClassCache = new HashMap(64);
    private static final Set<Class<?>> javaLanguageInterfaces;
    private static final Map<Method, Method> interfaceMethodCache;

    private static void registerCommonClasses(Class<?> ... commonClasses) {
        for (Class<?> clazz : commonClasses) {
            commonClassCache.put(clazz.getName(), clazz);
        }
    }

    @Nullable
    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    @Nullable
    public static ClassLoader overrideThreadContextClassLoader(@Nullable ClassLoader classLoaderToUse) {
        Thread currentThread = Thread.currentThread();
        ClassLoader threadContextClassLoader = currentThread.getContextClassLoader();
        if (classLoaderToUse != null && !classLoaderToUse.equals(threadContextClassLoader)) {
            currentThread.setContextClassLoader(classLoaderToUse);
            return threadContextClassLoader;
        }
        return null;
    }

    public static Class<?> forName(String name2, @Nullable ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        Assert.notNull((Object)name2, "Name must not be null");
        Class<?> clazz = ClassUtils.resolvePrimitiveClassName(name2);
        if (clazz == null) {
            clazz = commonClassCache.get(name2);
        }
        if (clazz != null) {
            return clazz;
        }
        if (name2.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name2.substring(0, name2.length() - ARRAY_SUFFIX.length());
            Class<?> elementClass = ClassUtils.forName(elementClassName, classLoader);
            return elementClass.arrayType();
        }
        if (name2.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && name2.endsWith(";")) {
            String elementName = name2.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), name2.length() - 1);
            Class<?> elementClass = ClassUtils.forName(elementName, classLoader);
            return elementClass.arrayType();
        }
        if (name2.startsWith(INTERNAL_ARRAY_PREFIX)) {
            String elementName = name2.substring(INTERNAL_ARRAY_PREFIX.length());
            Class<?> elementClass = ClassUtils.forName(elementName, classLoader);
            return elementClass.arrayType();
        }
        ClassLoader clToUse = classLoader;
        if (clToUse == null) {
            clToUse = ClassUtils.getDefaultClassLoader();
        }
        try {
            return Class.forName(name2, false, clToUse);
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = name2.lastIndexOf(46);
            int previousDotIndex = name2.lastIndexOf(46, lastDotIndex - 1);
            if (lastDotIndex != -1 && previousDotIndex != -1 && Character.isUpperCase(name2.charAt(previousDotIndex + 1))) {
                String nestedClassName = name2.substring(0, lastDotIndex) + "$" + name2.substring(lastDotIndex + 1);
                try {
                    return Class.forName(nestedClassName, false, clToUse);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    public static Class<?> resolveClassName(String className, @Nullable ClassLoader classLoader) throws IllegalArgumentException {
        try {
            return ClassUtils.forName(className, classLoader);
        }
        catch (IllegalAccessError err) {
            throw new IllegalStateException("Readability mismatch in inheritance hierarchy of class [" + className + "]: " + err.getMessage(), err);
        }
        catch (LinkageError err) {
            throw new IllegalArgumentException("Unresolvable class definition for class [" + className + "]", err);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Could not find class [" + className + "]", ex);
        }
    }

    public static boolean isPresent(String className, @Nullable ClassLoader classLoader) {
        try {
            ClassUtils.forName(className, classLoader);
            return true;
        }
        catch (IllegalAccessError err) {
            throw new IllegalStateException("Readability mismatch in inheritance hierarchy of class [" + className + "]: " + err.getMessage(), err);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isVisible(Class<?> clazz, @Nullable ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        try {
            if (clazz.getClassLoader() == classLoader) {
                return true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return ClassUtils.isLoadable(clazz, classLoader);
    }

    public static boolean isCacheSafe(Class<?> clazz, @Nullable ClassLoader classLoader) {
        Assert.notNull(clazz, "Class must not be null");
        try {
            ClassLoader target2 = clazz.getClassLoader();
            if (target2 == classLoader || target2 == null) {
                return true;
            }
            if (classLoader == null) {
                return false;
            }
            ClassLoader current2 = classLoader;
            while (current2 != null) {
                if ((current2 = current2.getParent()) != target2) continue;
                return true;
            }
            while (target2 != null) {
                if ((target2 = target2.getParent()) != classLoader) continue;
                return false;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return classLoader != null && ClassUtils.isLoadable(clazz, classLoader);
    }

    private static boolean isLoadable(Class<?> clazz, ClassLoader classLoader) {
        try {
            return clazz == classLoader.loadClass(clazz.getName());
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    @Nullable
    public static Class<?> resolvePrimitiveClassName(@Nullable String name2) {
        Class<?> result2 = null;
        if (name2 != null && name2.length() <= 7) {
            result2 = primitiveTypeNameMap.get(name2);
        }
        return result2;
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return primitiveWrapperTypeMap.containsKey(clazz);
    }

    public static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isPrimitive() || ClassUtils.isPrimitiveWrapper(clazz);
    }

    public static boolean isPrimitiveArray(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isArray() && ((Class)clazz.componentType()).isPrimitive();
    }

    public static boolean isPrimitiveWrapperArray(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isArray() && ClassUtils.isPrimitiveWrapper(clazz.componentType());
    }

    public static Class<?> resolvePrimitiveIfNecessary(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isPrimitive() && clazz != Void.TYPE ? primitiveTypeToWrapperMap.get(clazz) : clazz;
    }

    public static boolean isVoidType(@Nullable Class<?> type2) {
        return type2 == Void.TYPE || type2 == Void.class;
    }

    public static boolean isSimpleValueType(Class<?> type2) {
        return !ClassUtils.isVoidType(type2) && (ClassUtils.isPrimitiveOrWrapper(type2) || Enum.class.isAssignableFrom(type2) || CharSequence.class.isAssignableFrom(type2) || Number.class.isAssignableFrom(type2) || Date.class.isAssignableFrom(type2) || Temporal.class.isAssignableFrom(type2) || ZoneId.class.isAssignableFrom(type2) || TimeZone.class.isAssignableFrom(type2) || File.class.isAssignableFrom(type2) || Path.class.isAssignableFrom(type2) || Charset.class.isAssignableFrom(type2) || Currency.class.isAssignableFrom(type2) || InetAddress.class.isAssignableFrom(type2) || URI.class == type2 || URL.class == type2 || UUID.class == type2 || Locale.class == type2 || Pattern.class == type2 || Class.class == type2);
    }

    public static boolean isAssignable(Class<?> lhsType, Class<?> rhsType) {
        Assert.notNull(lhsType, "Left-hand side type must not be null");
        Assert.notNull(rhsType, "Right-hand side type must not be null");
        if (lhsType.isAssignableFrom(rhsType)) {
            return true;
        }
        if (lhsType.isPrimitive()) {
            Class<?> resolvedPrimitive = primitiveWrapperTypeMap.get(rhsType);
            return lhsType == resolvedPrimitive;
        }
        Class<?> resolvedWrapper = primitiveTypeToWrapperMap.get(rhsType);
        return resolvedWrapper != null && lhsType.isAssignableFrom(resolvedWrapper);
    }

    public static boolean isAssignableValue(Class<?> type2, @Nullable Object value2) {
        Assert.notNull(type2, "Type must not be null");
        return value2 != null ? ClassUtils.isAssignable(type2, value2.getClass()) : !type2.isPrimitive();
    }

    public static String convertResourcePathToClassName(String resourcePath) {
        Assert.notNull((Object)resourcePath, "Resource path must not be null");
        return resourcePath.replace('/', '.');
    }

    public static String convertClassNameToResourcePath(String className) {
        Assert.notNull((Object)className, "Class name must not be null");
        return className.replace('.', '/');
    }

    public static String addResourcePathToPackagePath(Class<?> clazz, String resourceName) {
        Assert.notNull((Object)resourceName, "Resource name must not be null");
        if (!resourceName.startsWith("/")) {
            return ClassUtils.classPackageAsResourcePath(clazz) + "/" + resourceName;
        }
        return ClassUtils.classPackageAsResourcePath(clazz) + resourceName;
    }

    public static String classPackageAsResourcePath(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(46);
        if (packageEndIndex == -1) {
            return "";
        }
        String packageName = className.substring(0, packageEndIndex);
        return packageName.replace('.', '/');
    }

    public static String classNamesToString(Class<?> ... classes) {
        return ClassUtils.classNamesToString(Arrays.asList(classes));
    }

    public static String classNamesToString(@Nullable Collection<Class<?>> classes) {
        if (CollectionUtils.isEmpty(classes)) {
            return ARRAY_SUFFIX;
        }
        StringJoiner stringJoiner = new StringJoiner(", ", INTERNAL_ARRAY_PREFIX, "]");
        for (Class<?> clazz : classes) {
            stringJoiner.add(clazz.getName());
        }
        return stringJoiner.toString();
    }

    public static Class<?>[] toClassArray(@Nullable Collection<Class<?>> collection) {
        return !CollectionUtils.isEmpty(collection) ? collection.toArray(EMPTY_CLASS_ARRAY) : EMPTY_CLASS_ARRAY;
    }

    public static Class<?>[] getAllInterfaces(Object instance) {
        Assert.notNull(instance, "Instance must not be null");
        return ClassUtils.getAllInterfacesForClass(instance.getClass());
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz) {
        return ClassUtils.getAllInterfacesForClass(clazz, null);
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz, @Nullable ClassLoader classLoader) {
        return ClassUtils.toClassArray(ClassUtils.getAllInterfacesForClassAsSet(clazz, classLoader));
    }

    public static Set<Class<?>> getAllInterfacesAsSet(Object instance) {
        Assert.notNull(instance, "Instance must not be null");
        return ClassUtils.getAllInterfacesForClassAsSet(instance.getClass());
    }

    public static Set<Class<?>> getAllInterfacesForClassAsSet(Class<?> clazz) {
        return ClassUtils.getAllInterfacesForClassAsSet(clazz, null);
    }

    public static Set<Class<?>> getAllInterfacesForClassAsSet(Class<?> clazz, @Nullable ClassLoader classLoader) {
        Assert.notNull(clazz, "Class must not be null");
        if (clazz.isInterface() && ClassUtils.isVisible(clazz, classLoader)) {
            return Collections.singleton(clazz);
        }
        LinkedHashSet interfaces2 = new LinkedHashSet();
        for (Class<?> current2 = clazz; current2 != null; current2 = current2.getSuperclass()) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = current2.getInterfaces()) {
                if (!ClassUtils.isVisible(ifc, classLoader)) continue;
                interfaces2.add(ifc);
            }
        }
        return interfaces2;
    }

    public static Class<?> createCompositeInterface(Class<?>[] interfaces2, @Nullable ClassLoader classLoader) {
        Assert.notEmpty((Object[])interfaces2, "Interface array must not be empty");
        return Proxy.getProxyClass(classLoader, interfaces2);
    }

    @Nullable
    public static Class<?> determineCommonAncestor(@Nullable Class<?> clazz1, @Nullable Class<?> clazz2) {
        if (clazz1 == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz1;
        }
        if (clazz1.isAssignableFrom(clazz2)) {
            return clazz1;
        }
        if (clazz2.isAssignableFrom(clazz1)) {
            return clazz2;
        }
        Class<?> ancestor = clazz1;
        do {
            if ((ancestor = ancestor.getSuperclass()) != null && Object.class != ancestor) continue;
            return null;
        } while (!ancestor.isAssignableFrom(clazz2));
        return ancestor;
    }

    public static boolean isJavaLanguageInterface(Class<?> ifc) {
        return javaLanguageInterfaces.contains(ifc);
    }

    public static boolean isStaticClass(Class<?> clazz) {
        return Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !ClassUtils.isStaticClass(clazz);
    }

    public static boolean isLambdaClass(Class<?> clazz) {
        return clazz.isSynthetic() && clazz.getSuperclass() == Object.class && clazz.getInterfaces().length > 0 && clazz.getName().contains("$$Lambda");
    }

    @Deprecated
    public static boolean isCglibProxy(Object object) {
        return ClassUtils.isCglibProxyClass(object.getClass());
    }

    @Deprecated
    public static boolean isCglibProxyClass(@Nullable Class<?> clazz) {
        return clazz != null && ClassUtils.isCglibProxyClassName(clazz.getName());
    }

    @Deprecated
    public static boolean isCglibProxyClassName(@Nullable String className) {
        return className != null && className.contains(CGLIB_CLASS_SEPARATOR);
    }

    public static Class<?> getUserClass(Object instance) {
        Assert.notNull(instance, "Instance must not be null");
        return ClassUtils.getUserClass(instance.getClass());
    }

    public static Class<?> getUserClass(Class<?> clazz) {
        Class<?> superclass2;
        if (clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && (superclass2 = clazz.getSuperclass()) != null && superclass2 != Object.class) {
            return superclass2;
        }
        return clazz;
    }

    @Nullable
    public static String getDescriptiveType(@Nullable Object value2) {
        if (value2 == null) {
            return null;
        }
        Class<?> clazz = value2.getClass();
        if (Proxy.isProxyClass(clazz)) {
            String prefix = clazz.getName() + " implementing ";
            StringJoiner result2 = new StringJoiner(",", prefix, "");
            for (Class<?> ifc : clazz.getInterfaces()) {
                result2.add(ifc.getName());
            }
            return result2.toString();
        }
        return clazz.getTypeName();
    }

    public static boolean matchesTypeName(Class<?> clazz, @Nullable String typeName) {
        return typeName != null && (typeName.equals(clazz.getTypeName()) || typeName.equals(clazz.getSimpleName()));
    }

    public static String getShortName(String className) {
        Assert.hasLength(className, "Class name must not be empty");
        int lastDotIndex = className.lastIndexOf(46);
        int nameEndIndex = className.indexOf(CGLIB_CLASS_SEPARATOR);
        if (nameEndIndex == -1) {
            nameEndIndex = className.length();
        }
        String shortName = className.substring(lastDotIndex + 1, nameEndIndex);
        shortName = shortName.replace('$', '.');
        return shortName;
    }

    public static String getShortName(Class<?> clazz) {
        return ClassUtils.getShortName(ClassUtils.getQualifiedName(clazz));
    }

    public static String getShortNameAsProperty(Class<?> clazz) {
        String shortName = ClassUtils.getShortName(clazz);
        int dotIndex = shortName.lastIndexOf(46);
        shortName = dotIndex != -1 ? shortName.substring(dotIndex + 1) : shortName;
        return StringUtils.uncapitalizeAsProperty(shortName);
    }

    public static String getClassFileName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        String className = clazz.getName();
        int lastDotIndex = className.lastIndexOf(46);
        return className.substring(lastDotIndex + 1) + CLASS_FILE_SUFFIX;
    }

    public static String getPackageName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return ClassUtils.getPackageName(clazz.getName());
    }

    public static String getPackageName(String fqClassName) {
        Assert.notNull((Object)fqClassName, "Class name must not be null");
        int lastDotIndex = fqClassName.lastIndexOf(46);
        return lastDotIndex != -1 ? fqClassName.substring(0, lastDotIndex) : "";
    }

    public static String getQualifiedName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.getTypeName();
    }

    public static String getQualifiedMethodName(Method method2) {
        return ClassUtils.getQualifiedMethodName(method2, null);
    }

    public static String getQualifiedMethodName(Method method2, @Nullable Class<?> clazz) {
        Assert.notNull((Object)method2, "Method must not be null");
        return (clazz != null ? clazz : method2.getDeclaringClass()).getName() + "." + method2.getName();
    }

    public static boolean hasConstructor(Class<?> clazz, Class<?> ... paramTypes) {
        return ClassUtils.getConstructorIfAvailable(clazz, paramTypes) != null;
    }

    @Nullable
    public static <T> Constructor<T> getConstructorIfAvailable(Class<T> clazz, Class<?> ... paramTypes) {
        Assert.notNull(clazz, "Class must not be null");
        try {
            return clazz.getConstructor(paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static boolean hasMethod(Class<?> clazz, Method method2) {
        Class<?>[] paramTypes;
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)method2, "Method must not be null");
        if (clazz == method2.getDeclaringClass()) {
            return true;
        }
        String methodName = method2.getName();
        return ClassUtils.getMethodOrNull(clazz, methodName, paramTypes = method2.getParameterTypes()) != null;
    }

    public static boolean hasMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        return ClassUtils.getMethodIfAvailable(clazz, methodName, paramTypes) != null;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)methodName, "Method name must not be null");
        if (paramTypes != null) {
            try {
                return clazz.getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Expected method not found: " + ex);
            }
        }
        Set<Method> candidates = ClassUtils.findMethodCandidatesByName(clazz, methodName);
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        if (candidates.isEmpty()) {
            throw new IllegalStateException("Expected method not found: " + clazz.getName() + "." + methodName);
        }
        throw new IllegalStateException("No unique method found: " + clazz.getName() + "." + methodName);
    }

    @Nullable
    public static Method getMethodIfAvailable(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)methodName, "Method name must not be null");
        if (paramTypes != null) {
            return ClassUtils.getMethodOrNull(clazz, methodName, paramTypes);
        }
        Set<Method> candidates = ClassUtils.findMethodCandidatesByName(clazz, methodName);
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        return null;
    }

    public static int getMethodCountForName(Class<?> clazz, String methodName) {
        Class<?>[] ifcs;
        Method[] declaredMethods;
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)methodName, "Method name must not be null");
        int count2 = 0;
        for (Method method2 : declaredMethods = clazz.getDeclaredMethods()) {
            if (!methodName.equals(method2.getName())) continue;
            ++count2;
        }
        for (Class<?> ifc : ifcs = clazz.getInterfaces()) {
            count2 += ClassUtils.getMethodCountForName(ifc, methodName);
        }
        if (clazz.getSuperclass() != null) {
            count2 += ClassUtils.getMethodCountForName(clazz.getSuperclass(), methodName);
        }
        return count2;
    }

    public static boolean hasAtLeastOneMethodWithName(Class<?> clazz, String methodName) {
        Class<?>[] ifcs;
        Method[] declaredMethods;
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)methodName, "Method name must not be null");
        for (Method method2 : declaredMethods = clazz.getDeclaredMethods()) {
            if (!method2.getName().equals(methodName)) continue;
            return true;
        }
        for (Class<?> ifc : ifcs = clazz.getInterfaces()) {
            if (!ClassUtils.hasAtLeastOneMethodWithName(ifc, methodName)) continue;
            return true;
        }
        return clazz.getSuperclass() != null && ClassUtils.hasAtLeastOneMethodWithName(clazz.getSuperclass(), methodName);
    }

    public static Method getMostSpecificMethod(Method method2, @Nullable Class<?> targetClass) {
        if (targetClass != null && targetClass != method2.getDeclaringClass() && (ClassUtils.isOverridable(method2, targetClass) || !method2.getDeclaringClass().isAssignableFrom(targetClass))) {
            try {
                if (Modifier.isPublic(method2.getModifiers())) {
                    try {
                        return targetClass.getMethod(method2.getName(), method2.getParameterTypes());
                    }
                    catch (NoSuchMethodException ex) {
                        return method2;
                    }
                }
                Method specificMethod = ReflectionUtils.findMethod(targetClass, method2.getName(), method2.getParameterTypes());
                return specificMethod != null ? specificMethod : method2;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return method2;
    }

    @Deprecated
    public static Method getInterfaceMethodIfPossible(Method method2) {
        return ClassUtils.getInterfaceMethodIfPossible(method2, null);
    }

    public static Method getInterfaceMethodIfPossible(Method method2, @Nullable Class<?> targetClass) {
        if (!Modifier.isPublic(method2.getModifiers()) || method2.getDeclaringClass().isInterface()) {
            return method2;
        }
        Method result2 = interfaceMethodCache.computeIfAbsent(method2, key2 -> ClassUtils.findInterfaceMethodIfPossible(key2, key2.getDeclaringClass(), Object.class));
        if (result2 == method2 && targetClass != null) {
            result2 = ClassUtils.findInterfaceMethodIfPossible(method2, targetClass, method2.getDeclaringClass());
        }
        return result2;
    }

    private static Method findInterfaceMethodIfPossible(Method method2, Class<?> startClass, Class<?> endClass) {
        Class<?>[] parameterTypes = null;
        for (Class<?> current2 = startClass; current2 != null && current2 != endClass; current2 = current2.getSuperclass()) {
            if (parameterTypes == null) {
                parameterTypes = method2.getParameterTypes();
            }
            for (Class<?> ifc : current2.getInterfaces()) {
                try {
                    return ifc.getMethod(method2.getName(), parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        return method2;
    }

    public static boolean isUserLevelMethod(Method method2) {
        Assert.notNull((Object)method2, "Method must not be null");
        return method2.isBridge() || !method2.isSynthetic() && !ClassUtils.isGroovyObjectMethod(method2);
    }

    private static boolean isGroovyObjectMethod(Method method2) {
        return method2.getDeclaringClass().getName().equals("groovy.lang.GroovyObject");
    }

    private static boolean isOverridable(Method method2, @Nullable Class<?> targetClass) {
        if ((method2.getModifiers() & 0x1A) != 0) {
            return false;
        }
        if ((method2.getModifiers() & 5) != 0) {
            return true;
        }
        return targetClass == null || ClassUtils.getPackageName(method2.getDeclaringClass()).equals(ClassUtils.getPackageName(targetClass));
    }

    @Nullable
    public static Method getStaticMethod(Class<?> clazz, String methodName, Class<?> ... args2) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)methodName, "Method name must not be null");
        try {
            Method method2 = clazz.getMethod(methodName, args2);
            return Modifier.isStatic(method2.getModifiers()) ? method2 : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    @Nullable
    private static Method getMethodOrNull(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static Set<Method> findMethodCandidatesByName(Class<?> clazz, String methodName) {
        Method[] methods2;
        HashSet<Method> candidates = new HashSet<Method>(1);
        for (Method method2 : methods2 = clazz.getMethods()) {
            if (!methodName.equals(method2.getName())) continue;
            candidates.add(method2);
        }
        return candidates;
    }

    static {
        interfaceMethodCache = new ConcurrentReferenceHashMap<Method, Method>(256);
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
        primitiveWrapperTypeMap.put(Void.class, Void.TYPE);
        for (Map.Entry<Class<?>, Class<?>> entry : primitiveWrapperTypeMap.entrySet()) {
            primitiveTypeToWrapperMap.put(entry.getValue(), entry.getKey());
            ClassUtils.registerCommonClasses(entry.getKey());
        }
        HashSet primitiveTypes = new HashSet(32);
        primitiveTypes.addAll(primitiveWrapperTypeMap.values());
        Collections.addAll(primitiveTypes, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class);
        for (Class clazz : primitiveTypes) {
            primitiveTypeNameMap.put(clazz.getName(), clazz);
        }
        ClassUtils.registerCommonClasses(Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class);
        ClassUtils.registerCommonClasses(Number.class, Number[].class, String.class, String[].class, Class.class, Class[].class, Object.class, Object[].class);
        ClassUtils.registerCommonClasses(Throwable.class, Exception.class, RuntimeException.class, Error.class, StackTraceElement.class, StackTraceElement[].class);
        ClassUtils.registerCommonClasses(Enum.class, Iterable.class, Iterator.class, Enumeration.class, Collection.class, List.class, Set.class, Map.class, Map.Entry.class, Optional.class);
        Class[] classArray = new Class[]{Serializable.class, Externalizable.class, Closeable.class, AutoCloseable.class, Cloneable.class, Comparable.class};
        ClassUtils.registerCommonClasses(classArray);
        javaLanguageInterfaces = Set.of(classArray);
    }
}

