/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class Assert {
    public static void state(boolean expression, String message2) {
        if (!expression) {
            throw new IllegalStateException(message2);
        }
    }

    public static void state(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalStateException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void isTrue(boolean expression, String message2) {
        if (!expression) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void isTrue(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void isNull(@Nullable Object object, String message2) {
        if (object != null) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void isNull(@Nullable Object object, Supplier<String> messageSupplier) {
        if (object != null) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void notNull(@Nullable Object object, String message2) {
        if (object == null) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void notNull(@Nullable Object object, Supplier<String> messageSupplier) {
        if (object == null) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void hasLength(@Nullable String text, String message2) {
        if (!StringUtils.hasLength(text)) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void hasLength(@Nullable String text, Supplier<String> messageSupplier) {
        if (!StringUtils.hasLength(text)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void hasText(@Nullable String text, String message2) {
        if (!StringUtils.hasText(text)) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void hasText(@Nullable String text, Supplier<String> messageSupplier) {
        if (!StringUtils.hasText(text)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void doesNotContain(@Nullable String textToSearch, String substring, String message2) {
        if (StringUtils.hasLength(textToSearch) && StringUtils.hasLength(substring) && textToSearch.contains(substring)) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void doesNotContain(@Nullable String textToSearch, String substring, Supplier<String> messageSupplier) {
        if (StringUtils.hasLength(textToSearch) && StringUtils.hasLength(substring) && textToSearch.contains(substring)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void notEmpty(@Nullable Object[] array2, String message2) {
        if (ObjectUtils.isEmpty(array2)) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void notEmpty(@Nullable Object[] array2, Supplier<String> messageSupplier) {
        if (ObjectUtils.isEmpty(array2)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void noNullElements(@Nullable Object[] array2, String message2) {
        if (array2 != null) {
            for (Object element : array2) {
                if (element != null) continue;
                throw new IllegalArgumentException(message2);
            }
        }
    }

    public static void noNullElements(@Nullable Object[] array2, Supplier<String> messageSupplier) {
        if (array2 != null) {
            for (Object element : array2) {
                if (element != null) continue;
                throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
            }
        }
    }

    public static void notEmpty(@Nullable Collection<?> collection, String message2) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void notEmpty(@Nullable Collection<?> collection, Supplier<String> messageSupplier) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void noNullElements(@Nullable Collection<?> collection, String message2) {
        if (collection != null) {
            for (Object element : collection) {
                if (element != null) continue;
                throw new IllegalArgumentException(message2);
            }
        }
    }

    public static void noNullElements(@Nullable Collection<?> collection, Supplier<String> messageSupplier) {
        if (collection != null) {
            for (Object element : collection) {
                if (element != null) continue;
                throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
            }
        }
    }

    public static void notEmpty(@Nullable Map<?, ?> map2, String message2) {
        if (CollectionUtils.isEmpty(map2)) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void notEmpty(@Nullable Map<?, ?> map2, Supplier<String> messageSupplier) {
        if (CollectionUtils.isEmpty(map2)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void isInstanceOf(Class<?> type2, @Nullable Object obj, String message2) {
        Assert.notNull(type2, "Type to check against must not be null");
        if (!type2.isInstance(obj)) {
            Assert.instanceCheckFailed(type2, obj, message2);
        }
    }

    public static void isInstanceOf(Class<?> type2, @Nullable Object obj, Supplier<String> messageSupplier) {
        Assert.notNull(type2, "Type to check against must not be null");
        if (!type2.isInstance(obj)) {
            Assert.instanceCheckFailed(type2, obj, Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void isInstanceOf(Class<?> type2, @Nullable Object obj) {
        Assert.isInstanceOf(type2, obj, "");
    }

    public static void isAssignable(Class<?> superType, @Nullable Class<?> subType, String message2) {
        Assert.notNull(superType, "Supertype to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            Assert.assignableCheckFailed(superType, subType, message2);
        }
    }

    public static void isAssignable(Class<?> superType, @Nullable Class<?> subType, Supplier<String> messageSupplier) {
        Assert.notNull(superType, "Supertype to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            Assert.assignableCheckFailed(superType, subType, Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) {
        Assert.isAssignable(superType, subType, "");
    }

    private static void instanceCheckFailed(Class<?> type2, @Nullable Object obj, @Nullable String msg) {
        String className = obj != null ? obj.getClass().getName() : "null";
        Object result2 = "";
        boolean defaultMessage = true;
        if (StringUtils.hasLength(msg)) {
            if (Assert.endsWithSeparator(msg)) {
                result2 = msg + " ";
            } else {
                result2 = Assert.messageWithTypeName(msg, className);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result2 = (String)result2 + "Object of class [" + className + "] must be an instance of " + type2;
        }
        throw new IllegalArgumentException((String)result2);
    }

    private static void assignableCheckFailed(Class<?> superType, @Nullable Class<?> subType, @Nullable String msg) {
        Object result2 = "";
        boolean defaultMessage = true;
        if (StringUtils.hasLength(msg)) {
            if (Assert.endsWithSeparator(msg)) {
                result2 = msg + " ";
            } else {
                result2 = Assert.messageWithTypeName(msg, subType);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result2 = (String)result2 + subType + " is not assignable to " + superType;
        }
        throw new IllegalArgumentException((String)result2);
    }

    private static boolean endsWithSeparator(String msg) {
        return msg.endsWith(":") || msg.endsWith(";") || msg.endsWith(",") || msg.endsWith(".");
    }

    private static String messageWithTypeName(String msg, @Nullable Object typeName) {
        return msg + (msg.endsWith(" ") ? "" : ": ") + typeName;
    }

    @Nullable
    private static String nullSafeGet(@Nullable Supplier<String> messageSupplier) {
        return messageSupplier != null ? messageSupplier.get() : null;
    }
}

