/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.Conventions;
import org.springframework.lang.Nullable;
import org.springframework.ui.Model;
import org.springframework.util.Assert;

public class ConcurrentModel
extends ConcurrentHashMap<String, Object>
implements Model {
    public ConcurrentModel() {
    }

    public ConcurrentModel(String attributeName, Object attributeValue) {
        this.addAttribute(attributeName, attributeValue);
    }

    public ConcurrentModel(Object attributeValue) {
        this.addAttribute(attributeValue);
    }

    @Override
    @Nullable
    public Object put(String key2, @Nullable Object value2) {
        if (value2 != null) {
            return super.put(key2, value2);
        }
        return this.remove(key2);
    }

    @Override
    public void putAll(Map<? extends String, ?> map2) {
        for (Map.Entry<String, ?> entry : map2.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public ConcurrentModel addAttribute(String attributeName, @Nullable Object attributeValue) {
        Assert.notNull((Object)attributeName, "Model attribute name must not be null");
        this.put(attributeName, attributeValue);
        return this;
    }

    @Override
    public ConcurrentModel addAttribute(Object attributeValue) {
        Collection collection;
        Assert.notNull(attributeValue, "Model attribute value must not be null");
        if (attributeValue instanceof Collection && (collection = (Collection)attributeValue).isEmpty()) {
            return this;
        }
        return this.addAttribute(Conventions.getVariableName(attributeValue), attributeValue);
    }

    @Override
    public ConcurrentModel addAllAttributes(@Nullable Collection<?> attributeValues) {
        if (attributeValues != null) {
            for (Object attributeValue : attributeValues) {
                this.addAttribute(attributeValue);
            }
        }
        return this;
    }

    @Override
    public ConcurrentModel addAllAttributes(@Nullable Map<String, ?> attributes) {
        if (attributes != null) {
            this.putAll((Map<? extends String, ?>)attributes);
        }
        return this;
    }

    @Override
    public ConcurrentModel mergeAttributes(@Nullable Map<String, ?> attributes) {
        if (attributes != null) {
            attributes.forEach((key2, value2) -> {
                if (!this.containsKey(key2)) {
                    this.put((String)key2, value2);
                }
            });
        }
        return this;
    }

    @Override
    public boolean containsAttribute(String attributeName) {
        return this.containsKey(attributeName);
    }

    @Override
    @Nullable
    public Object getAttribute(String attributeName) {
        return this.get(attributeName);
    }

    @Override
    public Map<String, Object> asMap() {
        return this;
    }
}

