/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.support.CronField;
import org.springframework.util.Assert;

final class QuartzCronField
extends CronField {
    private final CronField.Type rollForwardType;
    private final TemporalAdjuster adjuster;
    private final String value;

    private QuartzCronField(CronField.Type type2, TemporalAdjuster adjuster, String value2) {
        this(type2, type2, adjuster, value2);
    }

    private QuartzCronField(CronField.Type type2, CronField.Type rollForwardType, TemporalAdjuster adjuster, String value2) {
        super(type2);
        this.adjuster = adjuster;
        this.value = value2;
        this.rollForwardType = rollForwardType;
    }

    public static boolean isQuartzDaysOfMonthField(String value2) {
        return value2.contains("L") || value2.contains("W");
    }

    public static QuartzCronField parseDaysOfMonth(String value2) {
        int idx = value2.lastIndexOf(76);
        if (idx != -1) {
            TemporalAdjuster adjuster;
            if (idx != 0) {
                throw new IllegalArgumentException("Unrecognized characters before 'L' in '" + value2 + "'");
            }
            if (value2.length() == 2 && value2.charAt(1) == 'W') {
                adjuster = QuartzCronField.lastWeekdayOfMonth();
            } else if (value2.length() == 1) {
                adjuster = QuartzCronField.lastDayOfMonth();
            } else {
                int offset2 = Integer.parseInt(value2, idx + 1, value2.length(), 10);
                if (offset2 >= 0) {
                    throw new IllegalArgumentException("Offset '" + offset2 + " should be < 0 '" + value2 + "'");
                }
                adjuster = QuartzCronField.lastDayWithOffset(offset2);
            }
            return new QuartzCronField(CronField.Type.DAY_OF_MONTH, adjuster, value2);
        }
        idx = value2.lastIndexOf(87);
        if (idx != -1) {
            if (idx == 0) {
                throw new IllegalArgumentException("No day-of-month before 'W' in '" + value2 + "'");
            }
            if (idx != value2.length() - 1) {
                throw new IllegalArgumentException("Unrecognized characters after 'W' in '" + value2 + "'");
            }
            int dayOfMonth = Integer.parseInt(value2, 0, idx, 10);
            dayOfMonth = CronField.Type.DAY_OF_MONTH.checkValidValue(dayOfMonth);
            TemporalAdjuster adjuster = QuartzCronField.weekdayNearestTo(dayOfMonth);
            return new QuartzCronField(CronField.Type.DAY_OF_MONTH, adjuster, value2);
        }
        throw new IllegalArgumentException("No 'L' or 'W' found in '" + value2 + "'");
    }

    public static boolean isQuartzDaysOfWeekField(String value2) {
        return value2.contains("L") || value2.contains("#");
    }

    public static QuartzCronField parseDaysOfWeek(String value2) {
        int idx = value2.lastIndexOf(76);
        if (idx != -1) {
            if (idx != value2.length() - 1) {
                throw new IllegalArgumentException("Unrecognized characters after 'L' in '" + value2 + "'");
            }
            if (idx == 0) {
                throw new IllegalArgumentException("No day-of-week before 'L' in '" + value2 + "'");
            }
            DayOfWeek dayOfWeek = QuartzCronField.parseDayOfWeek(value2.substring(0, idx));
            TemporalAdjuster adjuster = QuartzCronField.lastInMonth(dayOfWeek);
            return new QuartzCronField(CronField.Type.DAY_OF_WEEK, CronField.Type.DAY_OF_MONTH, adjuster, value2);
        }
        idx = value2.lastIndexOf(35);
        if (idx != -1) {
            if (idx == 0) {
                throw new IllegalArgumentException("No day-of-week before '#' in '" + value2 + "'");
            }
            if (idx == value2.length() - 1) {
                throw new IllegalArgumentException("No ordinal after '#' in '" + value2 + "'");
            }
            DayOfWeek dayOfWeek = QuartzCronField.parseDayOfWeek(value2.substring(0, idx));
            int ordinal2 = Integer.parseInt(value2, idx + 1, value2.length(), 10);
            if (ordinal2 <= 0) {
                throw new IllegalArgumentException("Ordinal '" + ordinal2 + "' in '" + value2 + "' must be positive number ");
            }
            TemporalAdjuster adjuster = QuartzCronField.dayOfWeekInMonth(ordinal2, dayOfWeek);
            return new QuartzCronField(CronField.Type.DAY_OF_WEEK, CronField.Type.DAY_OF_MONTH, adjuster, value2);
        }
        throw new IllegalArgumentException("No 'L' or '#' found in '" + value2 + "'");
    }

    private static DayOfWeek parseDayOfWeek(String value2) {
        int dayOfWeek = Integer.parseInt(value2);
        if (dayOfWeek == 0) {
            dayOfWeek = 7;
        }
        try {
            return DayOfWeek.of(dayOfWeek);
        }
        catch (DateTimeException ex) {
            throw new IllegalArgumentException(ex.getMessage() + " '" + value2 + "'", ex);
        }
    }

    private static TemporalAdjuster atMidnight() {
        return temporal -> {
            if (temporal.isSupported(ChronoField.NANO_OF_DAY)) {
                return temporal.with(ChronoField.NANO_OF_DAY, 0L);
            }
            return temporal;
        };
    }

    private static TemporalAdjuster lastDayOfMonth() {
        TemporalAdjuster adjuster = TemporalAdjusters.lastDayOfMonth();
        return temporal -> {
            Temporal result2 = adjuster.adjustInto(temporal);
            return QuartzCronField.rollbackToMidnight(temporal, result2);
        };
    }

    private static TemporalAdjuster lastWeekdayOfMonth() {
        TemporalAdjuster adjuster = TemporalAdjusters.lastDayOfMonth();
        return temporal -> {
            Temporal lastDom = adjuster.adjustInto(temporal);
            int dow = lastDom.get(ChronoField.DAY_OF_WEEK);
            Temporal result2 = dow == 6 ? lastDom.minus(1L, ChronoUnit.DAYS) : (dow == 7 ? lastDom.minus(2L, ChronoUnit.DAYS) : lastDom);
            return QuartzCronField.rollbackToMidnight(temporal, result2);
        };
    }

    private static TemporalAdjuster lastDayWithOffset(int offset2) {
        Assert.isTrue(offset2 < 0, "Offset should be < 0");
        TemporalAdjuster adjuster = TemporalAdjusters.lastDayOfMonth();
        return temporal -> {
            Temporal result2 = adjuster.adjustInto(temporal).plus(offset2, ChronoUnit.DAYS);
            return QuartzCronField.rollbackToMidnight(temporal, result2);
        };
    }

    private static TemporalAdjuster weekdayNearestTo(int dayOfMonth) {
        return temporal -> {
            int current2 = CronField.Type.DAY_OF_MONTH.get(temporal);
            DayOfWeek dayOfWeek = DayOfWeek.from(temporal);
            if (current2 == dayOfMonth && QuartzCronField.isWeekday(dayOfWeek) || dayOfWeek == DayOfWeek.FRIDAY && current2 == dayOfMonth - 1 || dayOfWeek == DayOfWeek.MONDAY && current2 == dayOfMonth + 1 || dayOfWeek == DayOfWeek.MONDAY && dayOfMonth == 1 && current2 == 3) {
                return temporal;
            }
            int count2 = 0;
            while (count2++ < 366) {
                if (current2 == dayOfMonth) {
                    dayOfWeek = DayOfWeek.from(temporal);
                    if (dayOfWeek == DayOfWeek.SATURDAY) {
                        temporal = dayOfMonth != 1 ? temporal.minus(1L, ChronoUnit.DAYS) : temporal.plus(2L, ChronoUnit.DAYS);
                    } else if (dayOfWeek == DayOfWeek.SUNDAY) {
                        temporal = temporal.plus(1L, ChronoUnit.DAYS);
                    }
                    return QuartzCronField.atMidnight().adjustInto(temporal);
                }
                temporal = CronField.Type.DAY_OF_MONTH.elapseUntil(QuartzCronField.cast(temporal), dayOfMonth);
                current2 = CronField.Type.DAY_OF_MONTH.get(temporal);
            }
            return null;
        };
    }

    private static boolean isWeekday(DayOfWeek dayOfWeek) {
        return dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY;
    }

    private static TemporalAdjuster lastInMonth(DayOfWeek dayOfWeek) {
        TemporalAdjuster adjuster = TemporalAdjusters.lastInMonth(dayOfWeek);
        return temporal -> {
            Temporal result2 = adjuster.adjustInto(temporal);
            return QuartzCronField.rollbackToMidnight(temporal, result2);
        };
    }

    private static TemporalAdjuster dayOfWeekInMonth(int ordinal2, DayOfWeek dayOfWeek) {
        TemporalAdjuster adjuster = TemporalAdjusters.dayOfWeekInMonth(ordinal2, dayOfWeek);
        return temporal -> {
            Temporal result2 = adjuster.adjustInto(temporal);
            return QuartzCronField.rollbackToMidnight(temporal, result2);
        };
    }

    private static Temporal rollbackToMidnight(Temporal current2, Temporal result2) {
        if (result2.get(ChronoField.DAY_OF_MONTH) == current2.get(ChronoField.DAY_OF_MONTH)) {
            return current2;
        }
        return QuartzCronField.atMidnight().adjustInto(result2);
    }

    @Override
    @Nullable
    public <T extends Temporal & Comparable<? super T>> T nextOrSame(T temporal) {
        T result2 = this.adjust(temporal);
        if (result2 != null && ((Comparable<T>)result2).compareTo(temporal) < 0 && (result2 = this.adjust(temporal = this.rollForwardType.rollForward(temporal))) != null) {
            result2 = this.type().reset(result2);
        }
        return result2;
    }

    @Nullable
    private <T extends Temporal & Comparable<? super T>> T adjust(T temporal) {
        return (T)this.adjuster.adjustInto(temporal);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof QuartzCronField)) return false;
        QuartzCronField that = (QuartzCronField)other;
        if (this.type() != that.type()) return false;
        if (!this.value.equals(that.value)) return false;
        return true;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.type() + " '" + this.value + "'";
    }
}

