/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import java.time.DateTimeException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.ValueRange;
import java.util.function.BiFunction;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.support.BitsCronField;
import org.springframework.scheduling.support.CompositeCronField;
import org.springframework.scheduling.support.QuartzCronField;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class CronField {
    private static final String[] MONTHS = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private static final String[] DAYS = new String[]{"MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN"};
    private final Type type;

    protected CronField(Type type2) {
        this.type = type2;
    }

    public static CronField zeroNanos() {
        return BitsCronField.ZERO_NANOS;
    }

    public static CronField parseSeconds(String value2) {
        return BitsCronField.parseSeconds(value2);
    }

    public static CronField parseMinutes(String value2) {
        return BitsCronField.parseMinutes(value2);
    }

    public static CronField parseHours(String value2) {
        return BitsCronField.parseHours(value2);
    }

    public static CronField parseDaysOfMonth(String value2) {
        if (!QuartzCronField.isQuartzDaysOfMonthField(value2)) {
            return BitsCronField.parseDaysOfMonth(value2);
        }
        return CronField.parseList(value2, Type.DAY_OF_MONTH, (field, type2) -> {
            if (QuartzCronField.isQuartzDaysOfMonthField(field)) {
                return QuartzCronField.parseDaysOfMonth(field);
            }
            return BitsCronField.parseDaysOfMonth(field);
        });
    }

    public static CronField parseMonth(String value2) {
        value2 = CronField.replaceOrdinals(value2, MONTHS);
        return BitsCronField.parseMonth(value2);
    }

    public static CronField parseDaysOfWeek(String value2) {
        if (!QuartzCronField.isQuartzDaysOfWeekField(value2 = CronField.replaceOrdinals(value2, DAYS))) {
            return BitsCronField.parseDaysOfWeek(value2);
        }
        return CronField.parseList(value2, Type.DAY_OF_WEEK, (field, type2) -> {
            if (QuartzCronField.isQuartzDaysOfWeekField(field)) {
                return QuartzCronField.parseDaysOfWeek(field);
            }
            return BitsCronField.parseDaysOfWeek(field);
        });
    }

    private static CronField parseList(String value2, Type type2, BiFunction<String, Type, CronField> parseFieldFunction) {
        Assert.hasLength(value2, "Value must not be empty");
        String[] fields2 = StringUtils.delimitedListToStringArray(value2, ",");
        CronField[] cronFields = new CronField[fields2.length];
        for (int i2 = 0; i2 < fields2.length; ++i2) {
            cronFields[i2] = parseFieldFunction.apply(fields2[i2], type2);
        }
        return CompositeCronField.compose(cronFields, type2, value2);
    }

    private static String replaceOrdinals(String value2, String[] list2) {
        value2 = value2.toUpperCase();
        for (int i2 = 0; i2 < list2.length; ++i2) {
            String replacement2 = Integer.toString(i2 + 1);
            value2 = StringUtils.replace(value2, list2[i2], replacement2);
        }
        return value2;
    }

    @Nullable
    public abstract <T extends Temporal & Comparable<? super T>> T nextOrSame(T var1);

    protected Type type() {
        return this.type;
    }

    protected static <T extends Temporal & Comparable<? super T>> T cast(Temporal temporal) {
        return (T)temporal;
    }

    protected static enum Type {
        NANO(ChronoField.NANO_OF_SECOND, ChronoUnit.SECONDS, new ChronoField[0]),
        SECOND(ChronoField.SECOND_OF_MINUTE, ChronoUnit.MINUTES, ChronoField.NANO_OF_SECOND),
        MINUTE(ChronoField.MINUTE_OF_HOUR, ChronoUnit.HOURS, ChronoField.SECOND_OF_MINUTE, ChronoField.NANO_OF_SECOND),
        HOUR(ChronoField.HOUR_OF_DAY, ChronoUnit.DAYS, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.NANO_OF_SECOND),
        DAY_OF_MONTH(ChronoField.DAY_OF_MONTH, ChronoUnit.MONTHS, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.NANO_OF_SECOND),
        MONTH(ChronoField.MONTH_OF_YEAR, ChronoUnit.YEARS, ChronoField.DAY_OF_MONTH, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.NANO_OF_SECOND),
        DAY_OF_WEEK(ChronoField.DAY_OF_WEEK, ChronoUnit.WEEKS, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.NANO_OF_SECOND);

        private final ChronoField field;
        private final ChronoUnit higherOrder;
        private final ChronoField[] lowerOrders;

        private Type(ChronoField field, ChronoUnit higherOrder, ChronoField ... lowerOrders) {
            this.field = field;
            this.higherOrder = higherOrder;
            this.lowerOrders = lowerOrders;
        }

        public int get(Temporal date2) {
            return date2.get(this.field);
        }

        public ValueRange range() {
            return this.field.range();
        }

        public int checkValidValue(int value2) {
            if (this == DAY_OF_WEEK && value2 == 0) {
                return value2;
            }
            try {
                return this.field.checkValidIntValue(value2);
            }
            catch (DateTimeException ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
        }

        public <T extends Temporal & Comparable<? super T>> T elapseUntil(T temporal, int goal) {
            int current2 = this.get(temporal);
            ValueRange range = temporal.range(this.field);
            if (current2 < goal) {
                if (range.isValidIntValue(goal)) {
                    return CronField.cast(temporal.with(this.field, goal));
                }
                long amount = range.getMaximum() - (long)current2 + 1L;
                return this.field.getBaseUnit().addTo(temporal, amount);
            }
            long amount = (long)goal + range.getMaximum() - (long)current2 + 1L - range.getMinimum();
            return this.field.getBaseUnit().addTo(temporal, amount);
        }

        public <T extends Temporal & Comparable<? super T>> T rollForward(T temporal) {
            T result2 = this.higherOrder.addTo(temporal, 1L);
            ValueRange range = result2.range(this.field);
            return this.field.adjustInto(result2, range.getMinimum());
        }

        public <T extends Temporal> T reset(T temporal) {
            for (ChronoField lowerOrder : this.lowerOrders) {
                if (!temporal.isSupported(lowerOrder)) continue;
                temporal = lowerOrder.adjustInto(temporal, temporal.range(lowerOrder).getMinimum());
            }
            return temporal;
        }

        public String toString() {
            return this.field.toString();
        }
    }
}

