/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import java.time.temporal.Temporal;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.support.CronField;
import org.springframework.util.Assert;

final class CompositeCronField
extends CronField {
    private final CronField[] fields;
    private final String value;

    private CompositeCronField(CronField.Type type2, CronField[] fields2, String value2) {
        super(type2);
        this.fields = fields2;
        this.value = value2;
    }

    public static CronField compose(CronField[] fields2, CronField.Type type2, String value2) {
        Assert.notEmpty((Object[])fields2, "Fields must not be empty");
        Assert.hasLength(value2, "Value must not be empty");
        if (fields2.length == 1) {
            return fields2[0];
        }
        return new CompositeCronField(type2, fields2, value2);
    }

    @Override
    @Nullable
    public <T extends Temporal & Comparable<? super T>> T nextOrSame(T temporal) {
        Object result2 = null;
        for (CronField field : this.fields) {
            T candidate = field.nextOrSame(temporal);
            if (result2 != null && (candidate == null || ((Comparable<Object>)candidate).compareTo(result2) >= 0)) continue;
            result2 = candidate;
        }
        return result2;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeCronField)) {
            return false;
        }
        CompositeCronField other = (CompositeCronField)o;
        return this.type() == other.type() && this.value.equals(other.value);
    }

    public String toString() {
        return this.type() + " '" + this.value + "'";
    }
}

