/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import java.time.DateTimeException;
import java.time.temporal.Temporal;
import java.time.temporal.ValueRange;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.support.CronField;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class BitsCronField
extends CronField {
    public static final BitsCronField ZERO_NANOS = BitsCronField.forZeroNanos();
    private static final long MASK = -1L;
    private long bits;

    private BitsCronField(CronField.Type type2) {
        super(type2);
    }

    private static BitsCronField forZeroNanos() {
        BitsCronField field = new BitsCronField(CronField.Type.NANO);
        field.setBit(0);
        return field;
    }

    public static BitsCronField parseSeconds(String value2) {
        return BitsCronField.parseField(value2, CronField.Type.SECOND);
    }

    public static BitsCronField parseMinutes(String value2) {
        return BitsCronField.parseField(value2, CronField.Type.MINUTE);
    }

    public static BitsCronField parseHours(String value2) {
        return BitsCronField.parseField(value2, CronField.Type.HOUR);
    }

    public static BitsCronField parseDaysOfMonth(String value2) {
        return BitsCronField.parseDate(value2, CronField.Type.DAY_OF_MONTH);
    }

    public static BitsCronField parseMonth(String value2) {
        return BitsCronField.parseField(value2, CronField.Type.MONTH);
    }

    public static BitsCronField parseDaysOfWeek(String value2) {
        BitsCronField result2 = BitsCronField.parseDate(value2, CronField.Type.DAY_OF_WEEK);
        if (result2.getBit(0)) {
            result2.setBit(7);
            result2.clearBit(0);
        }
        return result2;
    }

    private static BitsCronField parseDate(String value2, CronField.Type type2) {
        if (value2.equals("?")) {
            value2 = "*";
        }
        return BitsCronField.parseField(value2, type2);
    }

    private static BitsCronField parseField(String value2, CronField.Type type2) {
        Assert.hasLength(value2, "Value must not be empty");
        Assert.notNull((Object)type2, "Type must not be null");
        try {
            String[] fields2;
            BitsCronField result2 = new BitsCronField(type2);
            for (String field : fields2 = StringUtils.delimitedListToStringArray(value2, ",")) {
                int delta;
                int slashPos = field.indexOf(47);
                if (slashPos == -1) {
                    ValueRange range = BitsCronField.parseRange(field, type2);
                    result2.setBits(range);
                    continue;
                }
                String rangeStr = field.substring(0, slashPos);
                String deltaStr = field.substring(slashPos + 1);
                ValueRange range = BitsCronField.parseRange(rangeStr, type2);
                if (rangeStr.indexOf(45) == -1) {
                    range = ValueRange.of(range.getMinimum(), type2.range().getMaximum());
                }
                if ((delta = Integer.parseInt(deltaStr)) <= 0) {
                    throw new IllegalArgumentException("Incrementer delta must be 1 or higher");
                }
                result2.setBits(range, delta);
            }
            return result2;
        }
        catch (IllegalArgumentException | DateTimeException ex) {
            String msg = ex.getMessage() + " '" + value2 + "'";
            throw new IllegalArgumentException(msg, ex);
        }
    }

    private static ValueRange parseRange(String value2, CronField.Type type2) {
        if (value2.equals("*")) {
            return type2.range();
        }
        int hyphenPos = value2.indexOf(45);
        if (hyphenPos == -1) {
            int result2 = type2.checkValidValue(Integer.parseInt(value2));
            return ValueRange.of(result2, result2);
        }
        int min2 = Integer.parseInt(value2, 0, hyphenPos, 10);
        int max2 = Integer.parseInt(value2, hyphenPos + 1, value2.length(), 10);
        min2 = type2.checkValidValue(min2);
        max2 = type2.checkValidValue(max2);
        if (type2 == CronField.Type.DAY_OF_WEEK && min2 == 7) {
            min2 = 0;
        }
        return ValueRange.of(min2, max2);
    }

    @Override
    @Nullable
    public <T extends Temporal & Comparable<? super T>> T nextOrSame(T temporal) {
        int current2 = this.type().get(temporal);
        int next2 = this.nextSetBit(current2);
        if (next2 == -1) {
            temporal = this.type().rollForward(temporal);
            next2 = this.nextSetBit(0);
        }
        if (next2 == current2) {
            return temporal;
        }
        int count2 = 0;
        current2 = this.type().get(temporal);
        while (current2 != next2 && count2++ < 366) {
            temporal = this.type().elapseUntil(temporal, next2);
            current2 = this.type().get(temporal);
            next2 = this.nextSetBit(current2);
            if (next2 != -1) continue;
            temporal = this.type().rollForward(temporal);
            next2 = this.nextSetBit(0);
        }
        if (count2 >= 366) {
            return null;
        }
        return this.type().reset(temporal);
    }

    boolean getBit(int index2) {
        return (this.bits & 1L << index2) != 0L;
    }

    private int nextSetBit(int fromIndex) {
        long result2 = this.bits & -1L << fromIndex;
        if (result2 != 0L) {
            return Long.numberOfTrailingZeros(result2);
        }
        return -1;
    }

    private void setBits(ValueRange range) {
        if (range.getMinimum() == range.getMaximum()) {
            this.setBit((int)range.getMinimum());
        } else {
            long minMask = -1L << (int)range.getMinimum();
            long maxMask = -1L >>> (int)(-(range.getMaximum() + 1L));
            this.bits |= minMask & maxMask;
        }
    }

    private void setBits(ValueRange range, int delta) {
        if (delta == 1) {
            this.setBits(range);
        } else {
            int i2 = (int)range.getMinimum();
            while ((long)i2 <= range.getMaximum()) {
                this.setBit(i2);
                i2 += delta;
            }
        }
    }

    private void setBit(int index2) {
        this.bits |= 1L << index2;
    }

    private void clearBit(int index2) {
        this.bits &= 1L << index2 ^ 0xFFFFFFFFFFFFFFFFL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof BitsCronField)) return false;
        BitsCronField that = (BitsCronField)other;
        if (this.type() != that.type()) return false;
        if (this.bits != that.bits) return false;
        return true;
    }

    public int hashCode() {
        return Long.hashCode(this.bits);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.type().toString());
        builder.append(" {");
        int i2 = this.nextSetBit(0);
        if (i2 != -1) {
            builder.append(i2);
            i2 = this.nextSetBit(i2 + 1);
            while (i2 != -1) {
                builder.append(", ");
                builder.append(i2);
                i2 = this.nextSetBit(i2 + 1);
            }
        }
        builder.append('}');
        return builder.toString();
    }
}

