/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.concurrent;

import jakarta.enterprise.concurrent.LastExecution;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.concurrent.ConcurrentTaskExecutor;
import org.springframework.scheduling.concurrent.ReschedulingRunnable;
import org.springframework.scheduling.support.TaskUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ErrorHandler;

public class ConcurrentTaskScheduler
extends ConcurrentTaskExecutor
implements TaskScheduler {
    private static final TimeUnit NANO = TimeUnit.NANOSECONDS;
    @Nullable
    private static Class<?> managedScheduledExecutorServiceClass;
    @Nullable
    private ScheduledExecutorService scheduledExecutor;
    private boolean enterpriseConcurrentScheduler = false;
    @Nullable
    private ErrorHandler errorHandler;
    private Clock clock = Clock.systemDefaultZone();

    @Deprecated(since="6.1")
    public ConcurrentTaskScheduler() {
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
        this.enterpriseConcurrentScheduler = false;
    }

    public ConcurrentTaskScheduler(@Nullable ScheduledExecutorService scheduledExecutor) {
        super(scheduledExecutor);
        if (scheduledExecutor != null) {
            this.initScheduledExecutor(scheduledExecutor);
        }
    }

    public ConcurrentTaskScheduler(Executor concurrentExecutor, ScheduledExecutorService scheduledExecutor) {
        super(concurrentExecutor);
        this.initScheduledExecutor(scheduledExecutor);
    }

    private void initScheduledExecutor(ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
        this.enterpriseConcurrentScheduler = managedScheduledExecutorServiceClass != null && managedScheduledExecutorServiceClass.isInstance(scheduledExecutor);
    }

    public void setScheduledExecutor(ScheduledExecutorService scheduledExecutor) {
        this.initScheduledExecutor(scheduledExecutor);
    }

    private ScheduledExecutorService getScheduledExecutor() {
        if (this.scheduledExecutor == null) {
            throw new IllegalStateException("No ScheduledExecutor is configured");
        }
        return this.scheduledExecutor;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        Assert.notNull((Object)errorHandler, "ErrorHandler must not be null");
        this.errorHandler = errorHandler;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, "Clock must not be null");
        this.clock = clock;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    @Override
    @Nullable
    public ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
        ScheduledExecutorService scheduleExecutorToUse = this.getScheduledExecutor();
        try {
            if (this.enterpriseConcurrentScheduler) {
                return new EnterpriseConcurrentTriggerScheduler().schedule(this.decorateTask(task, true), trigger);
            }
            ErrorHandler errorHandler = this.errorHandler != null ? this.errorHandler : TaskUtils.getDefaultErrorHandler(true);
            return new ReschedulingRunnable(task, trigger, this.clock, scheduleExecutorToUse, errorHandler).schedule();
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(scheduleExecutorToUse, task, ex);
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task, Instant startTime) {
        ScheduledExecutorService scheduleExecutorToUse = this.getScheduledExecutor();
        Duration delay = Duration.between(this.clock.instant(), startTime);
        try {
            return scheduleExecutorToUse.schedule(this.decorateTask(task, false), NANO.convert(delay), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(scheduleExecutorToUse, task, ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Instant startTime, Duration period) {
        ScheduledExecutorService scheduleExecutorToUse = this.getScheduledExecutor();
        Duration initialDelay = Duration.between(this.clock.instant(), startTime);
        try {
            return scheduleExecutorToUse.scheduleAtFixedRate(this.decorateTask(task, true), NANO.convert(initialDelay), NANO.convert(period), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(scheduleExecutorToUse, task, ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Duration period) {
        ScheduledExecutorService scheduleExecutorToUse = this.getScheduledExecutor();
        try {
            return scheduleExecutorToUse.scheduleAtFixedRate(this.decorateTask(task, true), 0L, NANO.convert(period), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(scheduleExecutorToUse, task, ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Instant startTime, Duration delay) {
        ScheduledExecutorService scheduleExecutorToUse = this.getScheduledExecutor();
        Duration initialDelay = Duration.between(this.clock.instant(), startTime);
        try {
            return scheduleExecutorToUse.scheduleWithFixedDelay(this.decorateTask(task, true), NANO.convert(initialDelay), NANO.convert(delay), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(scheduleExecutorToUse, task, ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Duration delay) {
        ScheduledExecutorService scheduleExecutorToUse = this.getScheduledExecutor();
        try {
            return scheduleExecutorToUse.scheduleWithFixedDelay(this.decorateTask(task, true), 0L, NANO.convert(delay), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(scheduleExecutorToUse, task, ex);
        }
    }

    private Runnable decorateTask(Runnable task, boolean isRepeatingTask) {
        Runnable result2 = TaskUtils.decorateTaskWithErrorHandler(task, this.errorHandler, isRepeatingTask);
        if (this.enterpriseConcurrentScheduler) {
            result2 = ConcurrentTaskExecutor.ManagedTaskBuilder.buildManagedTask(result2, task.toString());
        }
        return result2;
    }

    static {
        try {
            managedScheduledExecutorServiceClass = ClassUtils.forName("jakarta.enterprise.concurrent.ManagedScheduledExecutorService", ConcurrentTaskScheduler.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            managedScheduledExecutorServiceClass = null;
        }
    }

    private class EnterpriseConcurrentTriggerScheduler {
        private EnterpriseConcurrentTriggerScheduler() {
        }

        public ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
            ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)ConcurrentTaskScheduler.this.getScheduledExecutor();
            return executor.schedule(task, (jakarta.enterprise.concurrent.Trigger)new TriggerAdapter(trigger));
        }

        private static class TriggerAdapter
        implements jakarta.enterprise.concurrent.Trigger {
            private final Trigger adaptee;

            public TriggerAdapter(Trigger adaptee) {
                this.adaptee = adaptee;
            }

            @Nullable
            public Date getNextRunTime(@Nullable LastExecution le, Date taskScheduledTime) {
                Instant instant = this.adaptee.nextExecution(new LastExecutionAdapter(le));
                return instant != null ? Date.from(instant) : null;
            }

            public boolean skipRun(LastExecution lastExecutionInfo, Date scheduledRunTime) {
                return false;
            }

            private static class LastExecutionAdapter
            implements TriggerContext {
                @Nullable
                private final LastExecution le;

                public LastExecutionAdapter(@Nullable LastExecution le) {
                    this.le = le;
                }

                @Override
                @Nullable
                public Instant lastScheduledExecution() {
                    return this.le != null ? LastExecutionAdapter.toInstant(this.le.getScheduledStart()) : null;
                }

                @Override
                @Nullable
                public Instant lastActualExecution() {
                    return this.le != null ? LastExecutionAdapter.toInstant(this.le.getRunStart()) : null;
                }

                @Override
                @Nullable
                public Instant lastCompletion() {
                    return this.le != null ? LastExecutionAdapter.toInstant(this.le.getRunEnd()) : null;
                }

                @Nullable
                private static Instant toInstant(@Nullable Date date2) {
                    return date2 != null ? date2.toInstant() : null;
                }
            }
        }
    }
}

