/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.ResolvableType;
import org.springframework.jndi.JndiLocatorSupport;
import org.springframework.jndi.TypeMismatchNamingException;
import org.springframework.lang.Nullable;

public class SimpleJndiBeanFactory
extends JndiLocatorSupport
implements BeanFactory {
    private final Set<String> shareableResources = new HashSet<String>();
    private final Map<String, Object> singletonObjects = new HashMap<String, Object>();
    private final Map<String, Class<?>> resourceTypes = new HashMap();

    public SimpleJndiBeanFactory() {
        this.setResourceRef(true);
    }

    public void addShareableResource(String shareableResource) {
        this.shareableResources.add(shareableResource);
    }

    public void setShareableResources(String ... shareableResources) {
        Collections.addAll(this.shareableResources, shareableResources);
    }

    @Override
    public Object getBean(String name2) throws BeansException {
        return this.getBean(name2, Object.class);
    }

    @Override
    public <T> T getBean(String name2, Class<T> requiredType) throws BeansException {
        try {
            if (this.isSingleton(name2)) {
                return this.doGetSingleton(name2, requiredType);
            }
            return this.lookup(name2, requiredType);
        }
        catch (NameNotFoundException ex) {
            throw new NoSuchBeanDefinitionException(name2, "not found in JNDI environment");
        }
        catch (TypeMismatchNamingException ex) {
            throw new BeanNotOfRequiredTypeException(name2, ex.getRequiredType(), ex.getActualType());
        }
        catch (NamingException ex) {
            throw new BeanDefinitionStoreException("JNDI environment", name2, "JNDI lookup failed", ex);
        }
    }

    @Override
    public Object getBean(String name2, Object ... args2) throws BeansException {
        if (args2 != null) {
            throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support explicit bean creation arguments");
        }
        return this.getBean(name2);
    }

    @Override
    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return this.getBean(requiredType.getSimpleName(), requiredType);
    }

    @Override
    public <T> T getBean(Class<T> requiredType, Object ... args2) throws BeansException {
        if (args2 != null) {
            throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support explicit bean creation arguments");
        }
        return this.getBean(requiredType);
    }

    @Override
    public <T> ObjectProvider<T> getBeanProvider(final Class<T> requiredType) {
        return new ObjectProvider<T>(){

            @Override
            public T getObject() throws BeansException {
                return SimpleJndiBeanFactory.this.getBean(requiredType);
            }

            @Override
            public T getObject(Object ... args2) throws BeansException {
                return SimpleJndiBeanFactory.this.getBean(requiredType, args2);
            }

            @Override
            @Nullable
            public T getIfAvailable() throws BeansException {
                try {
                    return SimpleJndiBeanFactory.this.getBean(requiredType);
                }
                catch (NoUniqueBeanDefinitionException ex) {
                    throw ex;
                }
                catch (NoSuchBeanDefinitionException ex) {
                    return null;
                }
            }

            @Override
            @Nullable
            public T getIfUnique() throws BeansException {
                try {
                    return SimpleJndiBeanFactory.this.getBean(requiredType);
                }
                catch (NoSuchBeanDefinitionException ex) {
                    return null;
                }
            }
        };
    }

    @Override
    public <T> ObjectProvider<T> getBeanProvider(ResolvableType requiredType) {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support resolution by ResolvableType");
    }

    @Override
    public boolean containsBean(String name2) {
        if (this.singletonObjects.containsKey(name2) || this.resourceTypes.containsKey(name2)) {
            return true;
        }
        try {
            this.doGetType(name2);
            return true;
        }
        catch (NamingException ex) {
            return false;
        }
    }

    @Override
    public boolean isSingleton(String name2) throws NoSuchBeanDefinitionException {
        return this.shareableResources.contains(name2);
    }

    @Override
    public boolean isPrototype(String name2) throws NoSuchBeanDefinitionException {
        return !this.shareableResources.contains(name2);
    }

    @Override
    public boolean isTypeMatch(String name2, ResolvableType typeToMatch) throws NoSuchBeanDefinitionException {
        Class<?> type2 = this.getType(name2);
        return type2 != null && typeToMatch.isAssignableFrom(type2);
    }

    @Override
    public boolean isTypeMatch(String name2, @Nullable Class<?> typeToMatch) throws NoSuchBeanDefinitionException {
        Class<?> type2 = this.getType(name2);
        return typeToMatch == null || type2 != null && typeToMatch.isAssignableFrom(type2);
    }

    @Override
    @Nullable
    public Class<?> getType(String name2) throws NoSuchBeanDefinitionException {
        return this.getType(name2, true);
    }

    @Override
    @Nullable
    public Class<?> getType(String name2, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        try {
            return this.doGetType(name2);
        }
        catch (NameNotFoundException ex) {
            throw new NoSuchBeanDefinitionException(name2, "not found in JNDI environment");
        }
        catch (NamingException ex) {
            return null;
        }
    }

    @Override
    public String[] getAliases(String name2) {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doGetSingleton(String name2, @Nullable Class<T> requiredType) throws NamingException {
        Map<String, Object> map2 = this.singletonObjects;
        synchronized (map2) {
            Object singleton = this.singletonObjects.get(name2);
            if (singleton != null) {
                if (requiredType != null && !requiredType.isInstance(singleton)) {
                    throw new TypeMismatchNamingException(this.convertJndiName(name2), requiredType, singleton.getClass());
                }
                return (T)singleton;
            }
            T jndiObject = this.lookup(name2, requiredType);
            this.singletonObjects.put(name2, jndiObject);
            return jndiObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> doGetType(String name2) throws NamingException {
        if (this.isSingleton(name2)) {
            return this.doGetSingleton(name2, null).getClass();
        }
        Map<String, Class<?>> map2 = this.resourceTypes;
        synchronized (map2) {
            Class<?> type2 = this.resourceTypes.get(name2);
            if (type2 == null) {
                type2 = this.lookup(name2, null).getClass();
                this.resourceTypes.put(name2, type2);
            }
            return type2;
        }
    }
}

