/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import javax.naming.NamingException;
import org.springframework.core.env.PropertySource;
import org.springframework.jndi.JndiLocatorDelegate;
import org.springframework.lang.Nullable;

public class JndiPropertySource
extends PropertySource<JndiLocatorDelegate> {
    public JndiPropertySource(String name2) {
        this(name2, JndiLocatorDelegate.createDefaultResourceRefLocator());
    }

    public JndiPropertySource(String name2, JndiLocatorDelegate jndiLocator) {
        super(name2, jndiLocator);
    }

    @Override
    @Nullable
    public Object getProperty(String name2) {
        if (((JndiLocatorDelegate)this.getSource()).isResourceRef() && name2.indexOf(58) != -1) {
            return null;
        }
        try {
            Object value2 = ((JndiLocatorDelegate)this.source).lookup(name2);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("JNDI lookup for name [" + name2 + "] returned: [" + value2 + "]");
            }
            return value2;
        }
        catch (NamingException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("JNDI lookup for name [" + name2 + "] threw NamingException with message: " + ex.getMessage() + ". Returning null.");
            }
            return null;
        }
    }
}

