/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.javapoet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;

final class Util {
    private Util() {
    }

    static <K, V> Map<K, List<V>> immutableMultimap(Map<K, List<V>> multimap) {
        LinkedHashMap result2 = new LinkedHashMap();
        for (Map.Entry<K, List<V>> entry : multimap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            result2.put(entry.getKey(), Util.immutableList((Collection)entry.getValue()));
        }
        return Collections.unmodifiableMap(result2);
    }

    static <K, V> Map<K, V> immutableMap(Map<K, V> map2) {
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map2));
    }

    static void checkArgument(boolean condition, String format, Object ... args2) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(format, args2));
        }
    }

    static <T> T checkNotNull(T reference2, String format, Object ... args2) {
        if (reference2 == null) {
            throw new NullPointerException(String.format(format, args2));
        }
        return reference2;
    }

    static void checkState(boolean condition, String format, Object ... args2) {
        if (!condition) {
            throw new IllegalStateException(String.format(format, args2));
        }
    }

    static <T> List<T> immutableList(Collection<T> collection) {
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    static <T> Set<T> immutableSet(Collection<T> set2) {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(set2));
    }

    static <T> Set<T> union(Set<T> a, Set<T> b2) {
        LinkedHashSet<T> result2 = new LinkedHashSet<T>();
        result2.addAll(a);
        result2.addAll(b2);
        return result2;
    }

    static void requireExactlyOneOf(Set<Modifier> modifiers, Modifier ... mutuallyExclusive) {
        int count2 = 0;
        for (Modifier modifier : mutuallyExclusive) {
            if (!modifiers.contains((Object)modifier)) continue;
            ++count2;
        }
        Util.checkArgument(count2 == 1, "modifiers %s must contain one of %s", modifiers, Arrays.toString((Object[])mutuallyExclusive));
    }

    static String characterLiteralWithoutSingleQuotes(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return Character.isISOControl(c) ? String.format("\\u%04x", c) : Character.toString(c);
    }

    static String stringLiteralWithDoubleQuotes(String value2, String indent) {
        StringBuilder result2 = new StringBuilder(value2.length() + 2);
        result2.append('\"');
        for (int i2 = 0; i2 < value2.length(); ++i2) {
            char c = value2.charAt(i2);
            if (c == '\'') {
                result2.append("'");
                continue;
            }
            if (c == '\"') {
                result2.append("\\\"");
                continue;
            }
            result2.append(Util.characterLiteralWithoutSingleQuotes(c));
            if (c != '\n' || i2 + 1 >= value2.length()) continue;
            result2.append("\"\n").append(indent).append(indent).append("+ \"");
        }
        result2.append('\"');
        return result2.toString();
    }
}

