/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.support;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

public final class Netty5HeadersAdapter
implements MultiValueMap<String, String> {
    private final io.netty5.handler.codec.http.headers.HttpHeaders headers;

    public Netty5HeadersAdapter(io.netty5.handler.codec.http.headers.HttpHeaders headers) {
        Assert.notNull((Object)headers, "Headers must not be null");
        this.headers = headers;
    }

    @Override
    @Nullable
    public String getFirst(String key2) {
        CharSequence value2 = this.headers.get((CharSequence)key2);
        return value2 != null ? value2.toString() : null;
    }

    @Override
    public void add(String key2, @Nullable String value2) {
        if (value2 != null) {
            this.headers.add((CharSequence)key2, (CharSequence)value2);
        }
    }

    @Override
    public void addAll(String key2, List<? extends String> values2) {
        this.headers.add((CharSequence)key2, values2);
    }

    @Override
    public void addAll(MultiValueMap<String, String> values2) {
        values2.forEach((arg_0, arg_1) -> ((io.netty5.handler.codec.http.headers.HttpHeaders)this.headers).add(arg_0, arg_1));
    }

    @Override
    public void set(String key2, @Nullable String value2) {
        if (value2 != null) {
            this.headers.set((CharSequence)key2, (CharSequence)value2);
        }
    }

    @Override
    public void setAll(Map<String, String> values2) {
        values2.forEach((arg_0, arg_1) -> ((io.netty5.handler.codec.http.headers.HttpHeaders)this.headers).set(arg_0, arg_1));
    }

    @Override
    public Map<String, String> toSingleValueMap() {
        LinkedHashMap<String, String> singleValueMap = CollectionUtils.newLinkedHashMap(this.headers.size());
        this.headers.forEach(entry -> singleValueMap.putIfAbsent(((CharSequence)entry.getKey()).toString(), ((CharSequence)entry.getValue()).toString()));
        return singleValueMap;
    }

    @Override
    public int size() {
        return this.headers.names().size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        String headerName;
        return key2 instanceof String && this.headers.contains((CharSequence)(headerName = (String)key2));
    }

    @Override
    public boolean containsValue(Object value2) {
        return value2 instanceof String && StreamSupport.stream(this.headers.spliterator(), false).anyMatch(entry -> value2.equals(entry.getValue()));
    }

    @Override
    @Nullable
    public List<String> get(Object key2) {
        Iterator iterator = this.headers.valuesIterator((CharSequence)key2);
        if (iterator.hasNext()) {
            ArrayList<String> result2 = new ArrayList<String>();
            iterator.forEachRemaining(value2 -> result2.add(value2.toString()));
            return result2;
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> put(String key2, @Nullable List<String> value2) {
        Object previousValues = this.get(key2);
        this.headers.set((CharSequence)key2, value2);
        return previousValues;
    }

    @Override
    @Nullable
    public List<String> remove(Object key2) {
        if (key2 instanceof String) {
            String headerName = (String)key2;
            Object previousValues = this.get(headerName);
            this.headers.remove((CharSequence)headerName);
            return previousValues;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> map2) {
        map2.forEach((arg_0, arg_1) -> ((io.netty5.handler.codec.http.headers.HttpHeaders)this.headers).set(arg_0, arg_1));
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    @Override
    public Set<String> keySet() {
        return new HeaderNames();
    }

    @Override
    public Collection<List<String>> values() {
        ArrayList<List<String>> result2 = new ArrayList<List<String>>(this.headers.size());
        this.forEach((key2, value2) -> result2.add((List<String>)value2));
        return result2;
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return new AbstractSet<Map.Entry<String, List<String>>>(){

            @Override
            public Iterator<Map.Entry<String, List<String>>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return Netty5HeadersAdapter.this.headers.size();
            }
        };
    }

    public String toString() {
        return HttpHeaders.formatHeaders(this);
    }

    private class HeaderNames
    extends AbstractSet<String> {
        private HeaderNames() {
        }

        @Override
        public Iterator<String> iterator() {
            return new HeaderNamesIterator(Netty5HeadersAdapter.this.headers.names().iterator());
        }

        @Override
        public int size() {
            return Netty5HeadersAdapter.this.headers.names().size();
        }
    }

    private final class HeaderNamesIterator
    implements Iterator<String> {
        private final Iterator<CharSequence> iterator;
        @Nullable
        private CharSequence currentName;

        private HeaderNamesIterator(Iterator<CharSequence> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            this.currentName = this.iterator.next();
            return this.currentName.toString();
        }

        @Override
        public void remove() {
            if (this.currentName == null) {
                throw new IllegalStateException("No current Header in iterator");
            }
            if (!Netty5HeadersAdapter.this.headers.contains(this.currentName)) {
                throw new IllegalStateException("Header not present: " + this.currentName);
            }
            Netty5HeadersAdapter.this.headers.remove(this.currentName);
        }
    }

    private class HeaderEntry
    implements Map.Entry<String, List<String>> {
        private final CharSequence key;

        HeaderEntry(CharSequence key2) {
            this.key = key2;
        }

        @Override
        public String getKey() {
            return this.key.toString();
        }

        @Override
        public List<String> getValue() {
            List<String> values2 = Netty5HeadersAdapter.this.get(this.key);
            return values2 != null ? values2 : Collections.emptyList();
        }

        @Override
        public List<String> setValue(List<String> value2) {
            Object previousValues = this.getValue();
            Netty5HeadersAdapter.this.headers.set(this.key, value2);
            return previousValues;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<String, List<String>>> {
        private final Iterator<CharSequence> names;

        private EntryIterator() {
            this.names = Netty5HeadersAdapter.this.headers.names().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.names.hasNext();
        }

        @Override
        public Map.Entry<String, List<String>> next() {
            return new HeaderEntry(this.names.next());
        }
    }
}

