/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.support;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

public final class Netty4HeadersAdapter
implements MultiValueMap<String, String> {
    private final io.netty.handler.codec.http.HttpHeaders headers;

    public Netty4HeadersAdapter(io.netty.handler.codec.http.HttpHeaders headers) {
        Assert.notNull((Object)headers, "Headers must not be null");
        this.headers = headers;
    }

    @Override
    @Nullable
    public String getFirst(String key2) {
        return this.headers.get(key2);
    }

    @Override
    public void add(String key2, @Nullable String value2) {
        if (value2 != null) {
            this.headers.add(key2, (Object)value2);
        }
    }

    @Override
    public void addAll(String key2, List<? extends String> values2) {
        this.headers.add(key2, values2);
    }

    @Override
    public void addAll(MultiValueMap<String, String> values2) {
        values2.forEach((arg_0, arg_1) -> ((io.netty.handler.codec.http.HttpHeaders)this.headers).add(arg_0, arg_1));
    }

    @Override
    public void set(String key2, @Nullable String value2) {
        if (value2 != null) {
            this.headers.set(key2, (Object)value2);
        }
    }

    @Override
    public void setAll(Map<String, String> values2) {
        values2.forEach((arg_0, arg_1) -> ((io.netty.handler.codec.http.HttpHeaders)this.headers).set(arg_0, arg_1));
    }

    @Override
    public Map<String, String> toSingleValueMap() {
        LinkedHashMap<String, String> singleValueMap = CollectionUtils.newLinkedHashMap(this.headers.size());
        this.headers.entries().forEach((? super T entry) -> {
            if (!singleValueMap.containsKey(entry.getKey())) {
                singleValueMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        });
        return singleValueMap;
    }

    @Override
    public int size() {
        return this.headers.names().size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        String headerName;
        return key2 instanceof String && this.headers.contains(headerName = (String)key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        return value2 instanceof String && this.headers.entries().stream().anyMatch(entry -> value2.equals(entry.getValue()));
    }

    @Override
    @Nullable
    public List<String> get(Object key2) {
        if (this.containsKey(key2)) {
            return this.headers.getAll((String)key2);
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> put(String key2, @Nullable List<String> value2) {
        List previousValues = this.headers.getAll(key2);
        this.headers.set(key2, value2);
        return previousValues;
    }

    @Override
    @Nullable
    public List<String> remove(Object key2) {
        if (key2 instanceof String) {
            String headerName = (String)key2;
            List previousValues = this.headers.getAll(headerName);
            this.headers.remove(headerName);
            return previousValues;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> map2) {
        map2.forEach((arg_0, arg_1) -> ((io.netty.handler.codec.http.HttpHeaders)this.headers).set(arg_0, arg_1));
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    @Override
    public Set<String> keySet() {
        return new HeaderNames();
    }

    @Override
    public Collection<List<String>> values() {
        return this.headers.names().stream().map(arg_0 -> ((io.netty.handler.codec.http.HttpHeaders)this.headers).getAll(arg_0)).toList();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return new AbstractSet<Map.Entry<String, List<String>>>(){

            @Override
            public Iterator<Map.Entry<String, List<String>>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return Netty4HeadersAdapter.this.headers.size();
            }
        };
    }

    public String toString() {
        return HttpHeaders.formatHeaders(this);
    }

    private class HeaderNames
    extends AbstractSet<String> {
        private HeaderNames() {
        }

        @Override
        public Iterator<String> iterator() {
            return new HeaderNamesIterator(Netty4HeadersAdapter.this.headers.names().iterator());
        }

        @Override
        public int size() {
            return Netty4HeadersAdapter.this.headers.names().size();
        }
    }

    private final class HeaderNamesIterator
    implements Iterator<String> {
        private final Iterator<String> iterator;
        @Nullable
        private String currentName;

        private HeaderNamesIterator(Iterator<String> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            this.currentName = this.iterator.next();
            return this.currentName;
        }

        @Override
        public void remove() {
            if (this.currentName == null) {
                throw new IllegalStateException("No current Header in iterator");
            }
            if (!Netty4HeadersAdapter.this.headers.contains(this.currentName)) {
                throw new IllegalStateException("Header not present: " + this.currentName);
            }
            Netty4HeadersAdapter.this.headers.remove(this.currentName);
        }
    }

    private class HeaderEntry
    implements Map.Entry<String, List<String>> {
        private final String key;

        HeaderEntry(String key2) {
            this.key = key2;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public List<String> getValue() {
            return Netty4HeadersAdapter.this.headers.getAll(this.key);
        }

        @Override
        public List<String> setValue(List<String> value2) {
            List previousValues = Netty4HeadersAdapter.this.headers.getAll(this.key);
            Netty4HeadersAdapter.this.headers.set(this.key, value2);
            return previousValues;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<String, List<String>>> {
        private final Iterator<String> names;

        private EntryIterator() {
            this.names = Netty4HeadersAdapter.this.headers.names().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.names.hasNext();
        }

        @Override
        public Map.Entry<String, List<String>> next() {
            return new HeaderEntry(this.names.next());
        }
    }
}

