/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.support;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpMessage;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

public final class HttpComponentsHeadersAdapter
implements MultiValueMap<String, String> {
    private final HttpMessage message;

    public HttpComponentsHeadersAdapter(HttpMessage message2) {
        Assert.notNull((Object)message2, "Message must not be null");
        this.message = message2;
    }

    @Override
    @Nullable
    public String getFirst(String key2) {
        Header header = this.message.getFirstHeader(key2);
        return header != null ? header.getValue() : null;
    }

    @Override
    public void add(String key2, @Nullable String value2) {
        this.message.addHeader(key2, (Object)value2);
    }

    @Override
    public void addAll(String key2, List<? extends String> values2) {
        values2.forEach((? super T value2) -> this.add(key2, (String)value2));
    }

    @Override
    public void addAll(MultiValueMap<String, String> values2) {
        values2.forEach(this::addAll);
    }

    @Override
    public void set(String key2, @Nullable String value2) {
        this.message.setHeader(key2, (Object)value2);
    }

    @Override
    public void setAll(Map<String, String> values2) {
        values2.forEach(this::set);
    }

    @Override
    public Map<String, String> toSingleValueMap() {
        LinkedHashMap<String, String> map2 = CollectionUtils.newLinkedHashMap(this.size());
        this.message.headerIterator().forEachRemaining(h -> map2.putIfAbsent(h.getName(), h.getValue()));
        return map2;
    }

    @Override
    public int size() {
        return this.message.getHeaders().length;
    }

    @Override
    public boolean isEmpty() {
        return this.message.getHeaders().length == 0;
    }

    @Override
    public boolean containsKey(Object key2) {
        String headerName;
        return key2 instanceof String && this.message.containsHeader(headerName = (String)key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        return value2 instanceof String && Arrays.stream(this.message.getHeaders()).anyMatch(h -> h.getValue().equals(value2));
    }

    @Override
    @Nullable
    public List<String> get(Object key2) {
        ArrayList<String> values2 = null;
        if (this.containsKey(key2)) {
            Header[] headers = this.message.getHeaders((String)key2);
            values2 = new ArrayList<String>(headers.length);
            for (Header header : headers) {
                values2.add(header.getValue());
            }
        }
        return values2;
    }

    @Override
    @Nullable
    public List<String> put(String key2, List<String> values2) {
        Object oldValues = this.remove(key2);
        values2.forEach((? super T value2) -> this.add(key2, (String)value2));
        return oldValues;
    }

    @Override
    @Nullable
    public List<String> remove(Object key2) {
        if (key2 instanceof String) {
            String headerName = (String)key2;
            Object oldValues = this.get(key2);
            this.message.removeHeaders(headerName);
            return oldValues;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> map2) {
        map2.forEach(this::put);
    }

    @Override
    public void clear() {
        this.message.setHeaders(new Header[0]);
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> keys2 = new LinkedHashSet<String>(this.size());
        for (Header header : this.message.getHeaders()) {
            keys2.add(header.getName());
        }
        return keys2;
    }

    @Override
    public Collection<List<String>> values() {
        ArrayList<List<String>> values2 = new ArrayList<List<String>>(this.size());
        for (Header header : this.message.getHeaders()) {
            values2.add((List<String>)this.get(header.getName()));
        }
        return values2;
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return new AbstractSet<Map.Entry<String, List<String>>>(){

            @Override
            public Iterator<Map.Entry<String, List<String>>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return HttpComponentsHeadersAdapter.this.size();
            }
        };
    }

    public String toString() {
        return HttpHeaders.formatHeaders(this);
    }

    private class HeaderEntry
    implements Map.Entry<String, List<String>> {
        private final String key;

        HeaderEntry(String key2) {
            this.key = key2;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public List<String> getValue() {
            List<String> values2 = HttpComponentsHeadersAdapter.this.get(this.key);
            return values2 != null ? values2 : Collections.emptyList();
        }

        @Override
        public List<String> setValue(List<String> value2) {
            Object previousValues = this.getValue();
            HttpComponentsHeadersAdapter.this.put(this.key, value2);
            return previousValues;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<String, List<String>>> {
        private final Iterator<Header> iterator;

        private EntryIterator() {
            this.iterator = HttpComponentsHeadersAdapter.this.message.headerIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<String, List<String>> next() {
            return new HeaderEntry(this.iterator.next().getName());
        }
    }
}

