/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive.observation;

import io.micrometer.observation.transport.RequestReplyReceiverContext;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;

public class ServerRequestObservationContext
extends RequestReplyReceiverContext<ServerHttpRequest, ServerHttpResponse> {
    public static final String CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE = ServerRequestObservationContext.class.getName();
    private final Map<String, Object> attributes;
    @Nullable
    private String pathPattern;
    private boolean connectionAborted;

    public ServerRequestObservationContext(ServerHttpRequest request, ServerHttpResponse response, Map<String, Object> attributes) {
        super((req, key2) -> req.getHeaders().getFirst(key2));
        this.setCarrier(request);
        this.setResponse(response);
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public String getPathPattern() {
        return this.pathPattern;
    }

    public void setPathPattern(@Nullable String pathPattern) {
        this.pathPattern = pathPattern;
    }

    public boolean isConnectionAborted() {
        return this.connectionAborted;
    }

    public void setConnectionAborted(boolean connectionAborted) {
        this.connectionAborted = connectionAborted;
    }

    public static Optional<ServerRequestObservationContext> findCurrent(Map<String, Object> attributes) {
        return Optional.ofNullable((ServerRequestObservationContext)attributes.get(CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE));
    }
}

