/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

class UndertowHeadersAdapter
implements MultiValueMap<String, String> {
    private final HeaderMap headers;

    UndertowHeadersAdapter(HeaderMap headers) {
        this.headers = headers;
    }

    @Override
    public String getFirst(String key2) {
        return this.headers.getFirst(key2);
    }

    @Override
    public void add(String key2, @Nullable String value2) {
        this.headers.add(HttpString.tryFromString((String)key2), value2);
    }

    @Override
    public void addAll(String key2, List<? extends String> values2) {
        this.headers.addAll(HttpString.tryFromString((String)key2), values2);
    }

    @Override
    public void addAll(MultiValueMap<String, String> values2) {
        values2.forEach((key2, list2) -> this.headers.addAll(HttpString.tryFromString((String)key2), (Collection)list2));
    }

    @Override
    public void set(String key2, @Nullable String value2) {
        this.headers.put(HttpString.tryFromString((String)key2), value2);
    }

    @Override
    public void setAll(Map<String, String> values2) {
        values2.forEach((key2, list2) -> this.headers.put(HttpString.tryFromString((String)key2), list2));
    }

    @Override
    public Map<String, String> toSingleValueMap() {
        LinkedHashMap<String, String> singleValueMap = CollectionUtils.newLinkedHashMap(this.headers.size());
        this.headers.forEach(values2 -> singleValueMap.put(values2.getHeaderName().toString(), values2.getFirst()));
        return singleValueMap;
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.size() == 0;
    }

    @Override
    public boolean containsKey(Object key2) {
        String headerName;
        return key2 instanceof String && this.headers.contains(headerName = (String)key2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean containsValue(Object value2) {
        if (!(value2 instanceof String)) return false;
        if (!this.headers.getHeaderNames().stream().map(arg_0 -> ((HeaderMap)this.headers).get(arg_0)).anyMatch(values2 -> values2.contains(value2))) return false;
        return true;
    }

    @Override
    @Nullable
    public List<String> get(Object key2) {
        HeaderValues headerValues;
        if (key2 instanceof String) {
            String headerName = (String)key2;
            headerValues = this.headers.get(headerName);
        } else {
            headerValues = null;
        }
        return headerValues;
    }

    @Override
    @Nullable
    public List<String> put(String key2, List<String> value2) {
        HeaderValues previousValues = this.headers.get(key2);
        this.headers.putAll(HttpString.tryFromString((String)key2), value2);
        return previousValues;
    }

    @Override
    @Nullable
    public List<String> remove(Object key2) {
        String headerName;
        Collection removed;
        if (key2 instanceof String && (removed = this.headers.remove(headerName = (String)key2)) != null) {
            return new ArrayList<String>(removed);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> map2) {
        map2.forEach((key2, values2) -> this.headers.putAll(HttpString.tryFromString((String)key2), (Collection)values2));
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    @Override
    public Set<String> keySet() {
        return new HeaderNames();
    }

    @Override
    public Collection<List<String>> values() {
        return this.headers.getHeaderNames().stream().map(arg_0 -> ((HeaderMap)this.headers).get(arg_0)).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return new AbstractSet<Map.Entry<String, List<String>>>(){

            @Override
            public Iterator<Map.Entry<String, List<String>>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return UndertowHeadersAdapter.this.headers.size();
            }
        };
    }

    public String toString() {
        return HttpHeaders.formatHeaders(this);
    }

    private class HeaderNames
    extends AbstractSet<String> {
        private HeaderNames() {
        }

        @Override
        public Iterator<String> iterator() {
            return new HeaderNamesIterator(UndertowHeadersAdapter.this.headers.getHeaderNames().iterator());
        }

        @Override
        public int size() {
            return UndertowHeadersAdapter.this.headers.getHeaderNames().size();
        }
    }

    private final class HeaderNamesIterator
    implements Iterator<String> {
        private final Iterator<HttpString> iterator;
        @Nullable
        private String currentName;

        private HeaderNamesIterator(Iterator<HttpString> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            this.currentName = this.iterator.next().toString();
            return this.currentName;
        }

        @Override
        public void remove() {
            if (this.currentName == null) {
                throw new IllegalStateException("No current Header in iterator");
            }
            if (!UndertowHeadersAdapter.this.headers.contains(this.currentName)) {
                throw new IllegalStateException("Header not present: " + this.currentName);
            }
            UndertowHeadersAdapter.this.headers.remove(this.currentName);
        }
    }

    private class HeaderEntry
    implements Map.Entry<String, List<String>> {
        private final HttpString key;

        HeaderEntry(HttpString key2) {
            this.key = key2;
        }

        @Override
        public String getKey() {
            return this.key.toString();
        }

        @Override
        public List<String> getValue() {
            return UndertowHeadersAdapter.this.headers.get(this.key);
        }

        @Override
        public List<String> setValue(List<String> value2) {
            HeaderValues previousValues = UndertowHeadersAdapter.this.headers.get(this.key);
            UndertowHeadersAdapter.this.headers.putAll(this.key, value2);
            return previousValues;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<String, List<String>>> {
        private final Iterator<HttpString> names;

        private EntryIterator() {
            this.names = UndertowHeadersAdapter.this.headers.getHeaderNames().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.names.hasNext();
        }

        @Override
        public Map.Entry<String, List<String>> next() {
            return new HeaderEntry(this.names.next());
        }
    }
}

