/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

class TomcatHeadersAdapter
implements MultiValueMap<String, String> {
    private final MimeHeaders headers;

    TomcatHeadersAdapter(MimeHeaders headers) {
        this.headers = headers;
    }

    @Override
    public String getFirst(String key2) {
        return this.headers.getHeader(key2);
    }

    @Override
    public void add(String key2, @Nullable String value2) {
        this.headers.addValue(key2).setString(value2);
    }

    @Override
    public void addAll(String key2, List<? extends String> values2) {
        values2.forEach((? super T value2) -> this.add(key2, (String)value2));
    }

    @Override
    public void addAll(MultiValueMap<String, String> values2) {
        values2.forEach(this::addAll);
    }

    @Override
    public void set(String key2, @Nullable String value2) {
        this.headers.setValue(key2).setString(value2);
    }

    @Override
    public void setAll(Map<String, String> values2) {
        values2.forEach(this::set);
    }

    @Override
    public Map<String, String> toSingleValueMap() {
        LinkedHashMap<String, String> singleValueMap = CollectionUtils.newLinkedHashMap(this.headers.size());
        this.keySet().forEach((? super T key2) -> singleValueMap.put((String)key2, this.getFirst((String)key2)));
        return singleValueMap;
    }

    @Override
    public int size() {
        Enumeration<String> names2 = this.headers.names();
        int size2 = 0;
        while (names2.hasMoreElements()) {
            ++size2;
            names2.nextElement();
        }
        return size2;
    }

    @Override
    public boolean isEmpty() {
        return this.headers.size() == 0;
    }

    @Override
    public boolean containsKey(Object key2) {
        if (key2 instanceof String) {
            String headerName = (String)key2;
            return this.headers.findHeader(headerName, 0) != -1;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value2) {
        if (value2 instanceof String) {
            String text = (String)value2;
            MessageBytes messageBytes = MessageBytes.newInstance();
            messageBytes.setString(text);
            for (int i2 = 0; i2 < this.headers.size(); ++i2) {
                if (!this.headers.getValue(i2).equals(messageBytes)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public List<String> get(Object key2) {
        if (this.containsKey(key2)) {
            return Collections.list(this.headers.values((String)key2));
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> put(String key2, List<String> value2) {
        Object previousValues = this.get(key2);
        this.headers.removeHeader(key2);
        value2.forEach((? super T v) -> this.headers.addValue(key2).setString((String)v));
        return previousValues;
    }

    @Override
    @Nullable
    public List<String> remove(Object key2) {
        if (key2 instanceof String) {
            String headerName = (String)key2;
            Object previousValues = this.get(key2);
            this.headers.removeHeader(headerName);
            return previousValues;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> map2) {
        map2.forEach(this::put);
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    @Override
    public Set<String> keySet() {
        return new HeaderNames();
    }

    @Override
    public Collection<List<String>> values() {
        return this.keySet().stream().map(object -> this.get(object)).toList();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return new AbstractSet<Map.Entry<String, List<String>>>(){

            @Override
            public Iterator<Map.Entry<String, List<String>>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return TomcatHeadersAdapter.this.headers.size();
            }
        };
    }

    public String toString() {
        return HttpHeaders.formatHeaders(this);
    }

    private class HeaderNames
    extends AbstractSet<String> {
        private HeaderNames() {
        }

        @Override
        public Iterator<String> iterator() {
            return new HeaderNamesIterator(TomcatHeadersAdapter.this.headers.names());
        }

        @Override
        public int size() {
            Enumeration<String> names2 = TomcatHeadersAdapter.this.headers.names();
            int size2 = 0;
            while (names2.hasMoreElements()) {
                names2.nextElement();
                ++size2;
            }
            return size2;
        }
    }

    private final class HeaderNamesIterator
    implements Iterator<String> {
        private final Enumeration<String> enumeration;
        @Nullable
        private String currentName;

        private HeaderNamesIterator(Enumeration<String> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public String next() {
            this.currentName = this.enumeration.nextElement();
            return this.currentName;
        }

        @Override
        public void remove() {
            if (this.currentName == null) {
                throw new IllegalStateException("No current Header in iterator");
            }
            int index2 = TomcatHeadersAdapter.this.headers.findHeader(this.currentName, 0);
            if (index2 == -1) {
                throw new IllegalStateException("Header not present: " + this.currentName);
            }
            TomcatHeadersAdapter.this.headers.removeHeader(index2);
        }
    }

    private final class HeaderEntry
    implements Map.Entry<String, List<String>> {
        private final String key;

        HeaderEntry(String key2) {
            this.key = key2;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        @Nullable
        public List<String> getValue() {
            return TomcatHeadersAdapter.this.get(this.key);
        }

        @Override
        @Nullable
        public List<String> setValue(List<String> value2) {
            Object previous = this.getValue();
            TomcatHeadersAdapter.this.headers.removeHeader(this.key);
            TomcatHeadersAdapter.this.addAll(this.key, value2);
            return previous;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<String, List<String>>> {
        private final Enumeration<String> names;

        private EntryIterator() {
            this.names = TomcatHeadersAdapter.this.headers.names();
        }

        @Override
        public boolean hasNext() {
            return this.names.hasMoreElements();
        }

        @Override
        public Map.Entry<String, List<String>> next() {
            return new HeaderEntry(this.names.nextElement());
        }
    }
}

