/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

final class DefaultPathContainer
implements PathContainer {
    private static final PathContainer EMPTY_PATH = new DefaultPathContainer("", Collections.emptyList());
    private static final Map<Character, DefaultSeparator> SEPARATORS = new HashMap<Character, DefaultSeparator>(2);
    private final String path;
    private final List<PathContainer.Element> elements;

    private DefaultPathContainer(String path2, List<PathContainer.Element> elements) {
        this.path = path2;
        this.elements = Collections.unmodifiableList(elements);
    }

    @Override
    public String value() {
        return this.path;
    }

    @Override
    public List<PathContainer.Element> elements() {
        return this.elements;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof PathContainer)) return false;
        PathContainer that = (PathContainer)other;
        if (!this.value().equals(that.value())) return false;
        return true;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.value();
    }

    static PathContainer createFromUrlPath(String path2, PathContainer.Options options2) {
        int begin2;
        if (path2.isEmpty()) {
            return EMPTY_PATH;
        }
        char separator = options2.separator();
        DefaultSeparator separatorElement = SEPARATORS.get(Character.valueOf(separator));
        if (separatorElement == null) {
            throw new IllegalArgumentException("Unexpected separator: '" + separator + "'");
        }
        ArrayList<PathContainer.Element> elements = new ArrayList<PathContainer.Element>();
        if (path2.charAt(0) == separator) {
            begin2 = 1;
            elements.add(separatorElement);
        } else {
            begin2 = 0;
        }
        while (begin2 < path2.length()) {
            String segment;
            int end2 = path2.indexOf(separator, begin2);
            String string2 = segment = end2 != -1 ? path2.substring(begin2, end2) : path2.substring(begin2);
            if (!segment.isEmpty()) {
                elements.add(options2.shouldDecodeAndParseSegments() ? DefaultPathContainer.decodeAndParsePathSegment(segment) : DefaultPathSegment.from(segment, separatorElement));
            }
            if (end2 == -1) break;
            elements.add(separatorElement);
            begin2 = end2 + 1;
        }
        return new DefaultPathContainer(path2, elements);
    }

    private static PathContainer.PathSegment decodeAndParsePathSegment(String segment) {
        Charset charset = StandardCharsets.UTF_8;
        int index2 = segment.indexOf(59);
        if (index2 == -1) {
            String valueToMatch = StringUtils.uriDecode(segment, charset);
            return DefaultPathSegment.from(segment, valueToMatch);
        }
        String valueToMatch = StringUtils.uriDecode(segment.substring(0, index2), charset);
        String pathParameterContent = segment.substring(index2);
        MultiValueMap<String, String> parameters2 = DefaultPathContainer.parsePathParams(pathParameterContent, charset);
        return DefaultPathSegment.from(segment, valueToMatch, parameters2);
    }

    private static MultiValueMap<String, String> parsePathParams(String input, Charset charset) {
        LinkedMultiValueMap<String, String> result2 = new LinkedMultiValueMap<String, String>();
        int begin2 = 1;
        while (begin2 < input.length()) {
            int end2 = input.indexOf(59, begin2);
            String param = end2 != -1 ? input.substring(begin2, end2) : input.substring(begin2);
            DefaultPathContainer.parsePathParamValues(param, charset, result2);
            if (end2 == -1) break;
            begin2 = end2 + 1;
        }
        return result2;
    }

    private static void parsePathParamValues(String input, Charset charset, MultiValueMap<String, String> output) {
        if (StringUtils.hasText(input)) {
            int index2 = input.indexOf(61);
            if (index2 != -1) {
                String name2 = input.substring(0, index2);
                if (StringUtils.hasText(name2 = StringUtils.uriDecode(name2, charset))) {
                    String value2 = input.substring(index2 + 1);
                    for (String v : StringUtils.commaDelimitedListToStringArray(value2)) {
                        output.add(name2, StringUtils.uriDecode(v, charset));
                    }
                }
            } else {
                String name3 = StringUtils.uriDecode(input, charset);
                if (StringUtils.hasText(name3)) {
                    output.add(input, "");
                }
            }
        }
    }

    static PathContainer subPath(PathContainer container, int fromIndex, int toIndex) {
        List<PathContainer.Element> elements = container.elements();
        if (fromIndex == 0 && toIndex == elements.size()) {
            return container;
        }
        if (fromIndex == toIndex) {
            return EMPTY_PATH;
        }
        Assert.isTrue(fromIndex >= 0 && fromIndex < elements.size(), () -> "Invalid fromIndex: " + fromIndex);
        Assert.isTrue(toIndex >= 0 && toIndex <= elements.size(), () -> "Invalid toIndex: " + toIndex);
        Assert.isTrue(fromIndex < toIndex, () -> "fromIndex: " + fromIndex + " should be < toIndex " + toIndex);
        List<PathContainer.Element> subList = elements.subList(fromIndex, toIndex);
        String path2 = subList.stream().map(PathContainer.Element::value).collect(Collectors.joining(""));
        return new DefaultPathContainer(path2, subList);
    }

    static {
        SEPARATORS.put(Character.valueOf('/'), new DefaultSeparator('/', "%2F"));
        SEPARATORS.put(Character.valueOf('.'), new DefaultSeparator('.', "%2E"));
    }

    private static class DefaultSeparator
    implements PathContainer.Separator {
        private final String separator;
        private final String encodedSequence;

        DefaultSeparator(char separator, String encodedSequence) {
            this.separator = String.valueOf(separator);
            this.encodedSequence = encodedSequence;
        }

        @Override
        public String value() {
            return this.separator;
        }

        public String encodedSequence() {
            return this.encodedSequence;
        }
    }

    private static final class DefaultPathSegment
    implements PathContainer.PathSegment {
        private static final MultiValueMap<String, String> EMPTY_PARAMS = CollectionUtils.unmodifiableMultiValueMap(new LinkedMultiValueMap());
        private final String value;
        private final String valueToMatch;
        private final MultiValueMap<String, String> parameters;

        static DefaultPathSegment from(String value2, DefaultSeparator separator) {
            String valueToMatch = value2.contains(separator.encodedSequence()) ? value2.replaceAll(separator.encodedSequence(), separator.value()) : value2;
            return DefaultPathSegment.from(value2, valueToMatch);
        }

        static DefaultPathSegment from(String value2, String valueToMatch) {
            return new DefaultPathSegment(value2, valueToMatch, EMPTY_PARAMS);
        }

        static DefaultPathSegment from(String value2, String valueToMatch, MultiValueMap<String, String> params2) {
            return new DefaultPathSegment(value2, valueToMatch, CollectionUtils.unmodifiableMultiValueMap(params2));
        }

        private DefaultPathSegment(String value2, String valueToMatch, MultiValueMap<String, String> params2) {
            this.value = value2;
            this.valueToMatch = valueToMatch;
            this.parameters = params2;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String valueToMatch() {
            return this.valueToMatch;
        }

        @Override
        public char[] valueToMatchAsChars() {
            return this.valueToMatch.toCharArray();
        }

        @Override
        public MultiValueMap<String, String> parameters() {
            return this.parameters;
        }

        public boolean equals(@Nullable Object other) {
            PathContainer.PathSegment that;
            return this == other || other instanceof PathContainer.PathSegment && this.value.equals((that = (PathContainer.PathSegment)other).value());
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "[value='" + this.value + "']";
        }
    }
}

