/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.xml;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.xml.AbstractJaxb2HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.xml.StaxUtils;

public class Jaxb2CollectionHttpMessageConverter<T extends Collection>
extends AbstractJaxb2HttpMessageConverter<T>
implements GenericHttpMessageConverter<T> {
    private final XMLInputFactory inputFactory = this.createXmlInputFactory();

    @Override
    public boolean canRead(Class<?> clazz, @Nullable MediaType mediaType) {
        return false;
    }

    @Override
    public boolean canRead(Type type2, @Nullable Class<?> contextClass, @Nullable MediaType mediaType) {
        if (!(type2 instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type2;
        Type type3 = parameterizedType.getRawType();
        if (!(type3 instanceof Class)) {
            return false;
        }
        Class rawType = (Class)type3;
        if (!Collection.class.isAssignableFrom(rawType)) {
            return false;
        }
        if (parameterizedType.getActualTypeArguments().length != 1) {
            return false;
        }
        Type typeArgument = parameterizedType.getActualTypeArguments()[0];
        if (!(typeArgument instanceof Class)) {
            return false;
        }
        Class typeArgumentClass = (Class)typeArgument;
        return (typeArgumentClass.isAnnotationPresent(XmlRootElement.class) || typeArgumentClass.isAnnotationPresent(XmlType.class)) && this.canRead(mediaType);
    }

    @Override
    public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
        return false;
    }

    @Override
    public boolean canWrite(@Nullable Type type2, @Nullable Class<?> clazz, @Nullable MediaType mediaType) {
        return false;
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected T readFromSource(Class<? extends T> clazz, HttpHeaders headers, Source source2) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public T read(Type type2, @Nullable Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        ParameterizedType parameterizedType = (ParameterizedType)type2;
        T result2 = this.createCollection((Class)parameterizedType.getRawType());
        Class elementClass = (Class)parameterizedType.getActualTypeArguments()[0];
        try {
            Unmarshaller unmarshaller = this.createUnmarshaller(elementClass);
            XMLStreamReader streamReader = this.inputFactory.createXMLStreamReader(inputMessage.getBody());
            int event2 = this.moveToFirstChildOfRootElement(streamReader);
            while (event2 != 8) {
                if (elementClass.isAnnotationPresent(XmlRootElement.class)) {
                    result2.add((Object)unmarshaller.unmarshal(streamReader));
                } else if (elementClass.isAnnotationPresent(XmlType.class)) {
                    result2.add((Object)unmarshaller.unmarshal(streamReader, elementClass).getValue());
                } else {
                    throw new HttpMessageNotReadableException("Cannot unmarshal to [" + elementClass + "]", inputMessage);
                }
                event2 = this.moveToNextElement(streamReader);
            }
            return result2;
        }
        catch (XMLStreamException ex) {
            throw new HttpMessageNotReadableException("Failed to read XML stream: " + ex.getMessage(), ex, inputMessage);
        }
        catch (UnmarshalException ex) {
            throw new HttpMessageNotReadableException("Could not unmarshal to [" + elementClass + "]: " + ex, ex, inputMessage);
        }
        catch (JAXBException ex) {
            throw new HttpMessageConversionException("Invalid JAXB setup: " + ex.getMessage(), ex);
        }
    }

    protected T createCollection(Class<?> collectionClass) {
        if (!collectionClass.isInterface()) {
            try {
                return (T)((Collection)ReflectionUtils.accessibleConstructor(collectionClass, new Class[0]).newInstance(new Object[0]));
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Could not instantiate collection class: " + collectionClass.getName(), ex);
            }
        }
        if (List.class == collectionClass) {
            return (T)new ArrayList();
        }
        if (SortedSet.class == collectionClass) {
            return (T)new TreeSet();
        }
        return (T)new LinkedHashSet();
    }

    private int moveToFirstChildOfRootElement(XMLStreamReader streamReader) throws XMLStreamException {
        int event2 = streamReader.next();
        while (event2 != 1) {
            event2 = streamReader.next();
        }
        event2 = streamReader.next();
        while (event2 != 1 && event2 != 8) {
            event2 = streamReader.next();
        }
        return event2;
    }

    private int moveToNextElement(XMLStreamReader streamReader) throws XMLStreamException {
        int event2 = streamReader.getEventType();
        while (event2 != 1 && event2 != 8) {
            event2 = streamReader.next();
        }
        return event2;
    }

    @Override
    public void write(T t, @Nullable Type type2, @Nullable MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeToResult(T t, HttpHeaders headers, Result result2) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected XMLInputFactory createXmlInputFactory() {
        return StaxUtils.createDefensiveInputFactory();
    }
}

