/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class FormHttpMessageConverter
implements HttpMessageConverter<MultiValueMap<String, ?>> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final MediaType DEFAULT_FORM_DATA_MEDIA_TYPE = new MediaType(MediaType.APPLICATION_FORM_URLENCODED, DEFAULT_CHARSET);
    private List<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
    private List<HttpMessageConverter<?>> partConverters = new ArrayList();
    private Charset charset = DEFAULT_CHARSET;
    @Nullable
    private Charset multipartCharset;

    public FormHttpMessageConverter() {
        this.supportedMediaTypes.add(MediaType.APPLICATION_FORM_URLENCODED);
        this.supportedMediaTypes.add(MediaType.MULTIPART_FORM_DATA);
        this.supportedMediaTypes.add(MediaType.MULTIPART_MIXED);
        this.supportedMediaTypes.add(MediaType.MULTIPART_RELATED);
        this.partConverters.add(new ByteArrayHttpMessageConverter());
        this.partConverters.add(new StringHttpMessageConverter());
        this.partConverters.add(new ResourceHttpMessageConverter());
        this.applyDefaultCharset();
    }

    public void setSupportedMediaTypes(List<MediaType> supportedMediaTypes) {
        Assert.notNull(supportedMediaTypes, "'supportedMediaTypes' must not be null");
        this.supportedMediaTypes = new ArrayList<MediaType>(supportedMediaTypes);
    }

    public void addSupportedMediaTypes(MediaType ... supportedMediaTypes) {
        Assert.notNull((Object)supportedMediaTypes, "'supportedMediaTypes' must not be null");
        Assert.noNullElements((Object[])supportedMediaTypes, "'supportedMediaTypes' must not contain null elements");
        Collections.addAll(this.supportedMediaTypes, supportedMediaTypes);
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return Collections.unmodifiableList(this.supportedMediaTypes);
    }

    public void setPartConverters(List<HttpMessageConverter<?>> partConverters) {
        Assert.notEmpty(partConverters, "'partConverters' must not be empty");
        this.partConverters = partConverters;
    }

    public List<HttpMessageConverter<?>> getPartConverters() {
        return Collections.unmodifiableList(this.partConverters);
    }

    public void addPartConverter(HttpMessageConverter<?> partConverter) {
        Assert.notNull(partConverter, "'partConverter' must not be null");
        this.partConverters.add(partConverter);
    }

    public void setCharset(@Nullable Charset charset) {
        if (charset != this.charset) {
            this.charset = charset != null ? charset : DEFAULT_CHARSET;
            this.applyDefaultCharset();
        }
    }

    private void applyDefaultCharset() {
        for (HttpMessageConverter<?> candidate : this.partConverters) {
            AbstractHttpMessageConverter converter;
            if (!(candidate instanceof AbstractHttpMessageConverter) || (converter = (AbstractHttpMessageConverter)candidate).getDefaultCharset() == null) continue;
            converter.setDefaultCharset(this.charset);
        }
    }

    public void setMultipartCharset(Charset charset) {
        this.multipartCharset = charset;
    }

    @Override
    public boolean canRead(Class<?> clazz, @Nullable MediaType mediaType) {
        if (!MultiValueMap.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (mediaType == null) {
            return true;
        }
        for (MediaType supportedMediaType : this.getSupportedMediaTypes()) {
            if (supportedMediaType.getType().equalsIgnoreCase("multipart") || !supportedMediaType.includes(mediaType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
        if (!MultiValueMap.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (mediaType == null || MediaType.ALL.equals(mediaType)) {
            return true;
        }
        for (MediaType supportedMediaType : this.getSupportedMediaTypes()) {
            if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MultiValueMap<String, String> read(@Nullable Class<? extends MultiValueMap<String, ?>> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        MediaType contentType = inputMessage.getHeaders().getContentType();
        Charset charset = contentType != null && contentType.getCharset() != null ? contentType.getCharset() : this.charset;
        String body2 = StreamUtils.copyToString(inputMessage.getBody(), charset);
        String[] pairs = StringUtils.tokenizeToStringArray(body2, "&");
        LinkedMultiValueMap<String, String> result2 = new LinkedMultiValueMap<String, String>(pairs.length);
        for (String pair : pairs) {
            int idx = pair.indexOf(61);
            if (idx == -1) {
                result2.add(URLDecoder.decode(pair, charset), null);
                continue;
            }
            String name2 = URLDecoder.decode(pair.substring(0, idx), charset);
            String value2 = URLDecoder.decode(pair.substring(idx + 1), charset);
            result2.add(name2, value2);
        }
        return result2;
    }

    @Override
    public void write(MultiValueMap<String, ?> map2, @Nullable MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (this.isMultipart(map2, contentType)) {
            this.writeMultipart(map2, contentType, outputMessage);
        } else {
            this.writeForm(map2, contentType, outputMessage);
        }
    }

    private boolean isMultipart(MultiValueMap<String, ?> map2, @Nullable MediaType contentType) {
        if (contentType != null) {
            return contentType.getType().equalsIgnoreCase("multipart");
        }
        for (List values2 : map2.values()) {
            for (Object value2 : values2) {
                if (value2 == null || value2 instanceof String) continue;
                return true;
            }
        }
        return false;
    }

    private void writeForm(MultiValueMap<String, Object> formData, @Nullable MediaType contentType, HttpOutputMessage outputMessage) throws IOException {
        contentType = this.getFormContentType(contentType);
        outputMessage.getHeaders().setContentType(contentType);
        Charset charset = contentType.getCharset();
        Assert.notNull((Object)charset, "No charset");
        final byte[] bytes2 = this.serializeForm(formData, charset).getBytes(charset);
        outputMessage.getHeaders().setContentLength(bytes2.length);
        if (outputMessage instanceof StreamingHttpOutputMessage) {
            StreamingHttpOutputMessage streamingOutputMessage = (StreamingHttpOutputMessage)outputMessage;
            streamingOutputMessage.setBody(new StreamingHttpOutputMessage.Body(){

                @Override
                public void writeTo(OutputStream outputStream) throws IOException {
                    StreamUtils.copy(bytes2, outputStream);
                }

                @Override
                public boolean repeatable() {
                    return true;
                }
            });
        } else {
            StreamUtils.copy(bytes2, outputMessage.getBody());
        }
    }

    protected MediaType getFormContentType(@Nullable MediaType contentType) {
        if (contentType == null) {
            return DEFAULT_FORM_DATA_MEDIA_TYPE;
        }
        if (contentType.getCharset() == null) {
            return new MediaType(contentType, this.charset);
        }
        return contentType;
    }

    protected String serializeForm(MultiValueMap<String, Object> formData, Charset charset) {
        StringBuilder builder = new StringBuilder();
        formData.forEach((name2, values2) -> {
            if (name2 == null) {
                Assert.isTrue(CollectionUtils.isEmpty(values2), () -> "Null name in form data: " + formData);
                return;
            }
            values2.forEach(value2 -> {
                if (builder.length() != 0) {
                    builder.append('&');
                }
                builder.append(URLEncoder.encode(name2, charset));
                if (value2 != null) {
                    builder.append('=');
                    builder.append(URLEncoder.encode(String.valueOf(value2), charset));
                }
            });
        });
        return builder.toString();
    }

    private void writeMultipart(MultiValueMap<String, Object> parts, @Nullable MediaType contentType, HttpOutputMessage outputMessage) throws IOException {
        if (contentType == null) {
            contentType = MediaType.MULTIPART_FORM_DATA;
        }
        LinkedHashMap<String, String> parameters2 = new LinkedHashMap<String, String>(contentType.getParameters().size() + 2);
        parameters2.putAll(contentType.getParameters());
        byte[] boundary = this.generateMultipartBoundary();
        if (!(this.isFilenameCharsetSet() || this.charset.equals(StandardCharsets.UTF_8) || this.charset.equals(StandardCharsets.US_ASCII))) {
            parameters2.put("charset", this.charset.name());
        }
        parameters2.put("boundary", new String(boundary, StandardCharsets.US_ASCII));
        contentType = new MediaType(contentType, parameters2);
        outputMessage.getHeaders().setContentType(contentType);
        if (outputMessage instanceof StreamingHttpOutputMessage) {
            StreamingHttpOutputMessage streamingOutputMessage = (StreamingHttpOutputMessage)outputMessage;
            streamingOutputMessage.setBody(outputStream -> {
                this.writeParts(outputStream, parts, boundary);
                FormHttpMessageConverter.writeEnd(outputStream, boundary);
            });
        } else {
            this.writeParts(outputMessage.getBody(), parts, boundary);
            FormHttpMessageConverter.writeEnd(outputMessage.getBody(), boundary);
        }
    }

    private boolean isFilenameCharsetSet() {
        return this.multipartCharset != null;
    }

    private void writeParts(OutputStream os, MultiValueMap<String, Object> parts, byte[] boundary) throws IOException {
        for (Map.Entry entry : parts.entrySet()) {
            String name2 = (String)entry.getKey();
            for (Object part : (List)entry.getValue()) {
                if (part == null) continue;
                this.writeBoundary(os, boundary);
                this.writePart(name2, this.getHttpEntity(part), os);
                FormHttpMessageConverter.writeNewLine(os);
            }
        }
    }

    private void writePart(String name2, HttpEntity<?> partEntity, OutputStream os) throws IOException {
        Object partBody = partEntity.getBody();
        if (partBody == null) {
            throw new IllegalStateException("Empty body for part '" + name2 + "': " + partEntity);
        }
        Class<?> partType = partBody.getClass();
        HttpHeaders partHeaders = partEntity.getHeaders();
        MediaType partContentType = partHeaders.getContentType();
        for (HttpMessageConverter<?> messageConverter : this.partConverters) {
            if (!messageConverter.canWrite(partType, partContentType)) continue;
            Charset charset = this.isFilenameCharsetSet() ? StandardCharsets.US_ASCII : this.charset;
            MultipartHttpOutputMessage multipartMessage = new MultipartHttpOutputMessage(os, charset);
            String filename2 = this.getFilename(partBody);
            ContentDisposition.Builder cd = ContentDisposition.formData().name(name2);
            if (filename2 != null) {
                cd.filename(filename2, this.multipartCharset);
            }
            multipartMessage.getHeaders().setContentDisposition(cd.build());
            if (!partHeaders.isEmpty()) {
                multipartMessage.getHeaders().putAll(partHeaders);
            }
            messageConverter.write(partBody, partContentType, multipartMessage);
            return;
        }
        throw new HttpMessageNotWritableException("Could not write request: no suitable HttpMessageConverter found for request type [" + partType.getName() + "]");
    }

    protected byte[] generateMultipartBoundary() {
        return MimeTypeUtils.generateMultipartBoundary();
    }

    protected HttpEntity<?> getHttpEntity(Object part) {
        HttpEntity<Object> httpEntity;
        if (part instanceof HttpEntity) {
            HttpEntity httpEntity2 = (HttpEntity)part;
            httpEntity = httpEntity2;
        } else {
            httpEntity = new HttpEntity<Object>(part);
        }
        return httpEntity;
    }

    @Nullable
    protected String getFilename(Object part) {
        if (part instanceof Resource) {
            Resource resource = (Resource)part;
            return resource.getFilename();
        }
        return null;
    }

    private void writeBoundary(OutputStream os, byte[] boundary) throws IOException {
        os.write(45);
        os.write(45);
        os.write(boundary);
        FormHttpMessageConverter.writeNewLine(os);
    }

    private static void writeEnd(OutputStream os, byte[] boundary) throws IOException {
        os.write(45);
        os.write(45);
        os.write(boundary);
        os.write(45);
        os.write(45);
        FormHttpMessageConverter.writeNewLine(os);
    }

    private static void writeNewLine(OutputStream os) throws IOException {
        os.write(13);
        os.write(10);
    }

    private static class MultipartHttpOutputMessage
    implements HttpOutputMessage {
        private final OutputStream outputStream;
        private final Charset charset;
        private final HttpHeaders headers = new HttpHeaders();
        private boolean headersWritten = false;

        public MultipartHttpOutputMessage(OutputStream outputStream, Charset charset) {
            this.outputStream = new MultipartOutputStream(outputStream);
            this.charset = charset;
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.headersWritten ? HttpHeaders.readOnlyHttpHeaders(this.headers) : this.headers;
        }

        @Override
        public OutputStream getBody() throws IOException {
            this.writeHeaders();
            return this.outputStream;
        }

        private void writeHeaders() throws IOException {
            if (!this.headersWritten) {
                for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                    byte[] headerName = this.getBytes(entry.getKey());
                    for (String headerValueString : entry.getValue()) {
                        byte[] headerValue = this.getBytes(headerValueString);
                        this.outputStream.write(headerName);
                        this.outputStream.write(58);
                        this.outputStream.write(32);
                        this.outputStream.write(headerValue);
                        FormHttpMessageConverter.writeNewLine(this.outputStream);
                    }
                }
                FormHttpMessageConverter.writeNewLine(this.outputStream);
                this.headersWritten = true;
            }
        }

        private byte[] getBytes(String name2) {
            return name2.getBytes(this.charset);
        }
    }

    private static class MultipartOutputStream
    extends FilterOutputStream {
        public MultipartOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b2, int off, int let) throws IOException {
            this.out.write(b2, off, let);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

