/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.modules.SerializersModule;
import org.springframework.core.GenericTypeResolver;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractGenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;

public abstract class AbstractKotlinSerializationHttpMessageConverter<T extends SerialFormat>
extends AbstractGenericHttpMessageConverter<Object> {
    private final Map<Type, KSerializer<Object>> serializerCache = new ConcurrentReferenceHashMap<Type, KSerializer<Object>>();
    private final T format;

    protected AbstractKotlinSerializationHttpMessageConverter(T format, MediaType ... supportedMediaTypes) {
        super(supportedMediaTypes);
        this.format = format;
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return this.serializer(clazz) != null;
    }

    @Override
    public boolean canRead(Type type2, @Nullable Class<?> contextClass, @Nullable MediaType mediaType) {
        if (this.serializer(GenericTypeResolver.resolveType(type2, contextClass)) != null) {
            return this.canRead(mediaType);
        }
        return false;
    }

    @Override
    public boolean canWrite(@Nullable Type type2, Class<?> clazz, @Nullable MediaType mediaType) {
        if (this.serializer(type2 != null ? GenericTypeResolver.resolveType(type2, clazz) : clazz) != null) {
            return this.canWrite(mediaType);
        }
        return false;
    }

    @Override
    public final Object read(Type type2, @Nullable Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        Type resolvedType = GenericTypeResolver.resolveType(type2, contextClass);
        KSerializer<Object> serializer = this.serializer(resolvedType);
        if (serializer == null) {
            throw new HttpMessageNotReadableException("Could not find KSerializer for " + resolvedType, inputMessage);
        }
        return this.readInternal(serializer, this.format, inputMessage);
    }

    @Override
    protected final Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        KSerializer<Object> serializer = this.serializer(clazz);
        if (serializer == null) {
            throw new HttpMessageNotReadableException("Could not find KSerializer for " + clazz, inputMessage);
        }
        return this.readInternal(serializer, this.format, inputMessage);
    }

    protected abstract Object readInternal(KSerializer<Object> var1, T var2, HttpInputMessage var3) throws IOException, HttpMessageNotReadableException;

    @Override
    protected final void writeInternal(Object object, @Nullable Type type2, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Class<?> resolvedType = type2 != null ? type2 : object.getClass();
        KSerializer<Object> serializer = this.serializer(resolvedType);
        if (serializer == null) {
            throw new HttpMessageNotWritableException("Could not find KSerializer for " + resolvedType);
        }
        this.writeInternal(object, serializer, this.format, outputMessage);
    }

    protected abstract void writeInternal(Object var1, KSerializer<Object> var2, T var3, HttpOutputMessage var4) throws IOException, HttpMessageNotWritableException;

    @Nullable
    private KSerializer<Object> serializer(Type type2) {
        KSerializer serializer = this.serializerCache.get(type2);
        if (serializer == null) {
            try {
                serializer = SerializersKt.serializerOrNull((SerializersModule)this.format.getSerializersModule(), (Type)type2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (serializer != null) {
                if (this.hasPolymorphism(serializer.getDescriptor(), new HashSet<String>())) {
                    return null;
                }
                this.serializerCache.put(type2, (KSerializer<Object>)serializer);
            }
        }
        return serializer;
    }

    private boolean hasPolymorphism(SerialDescriptor descriptor, Set<String> alreadyProcessed) {
        alreadyProcessed.add(descriptor.getSerialName());
        if (descriptor.getKind().equals(PolymorphicKind.OPEN.INSTANCE)) {
            return true;
        }
        for (int i2 = 0; i2 < descriptor.getElementsCount(); ++i2) {
            SerialDescriptor elementDescriptor = descriptor.getElementDescriptor(i2);
            if (alreadyProcessed.contains(elementDescriptor.getSerialName()) || !this.hasPolymorphism(elementDescriptor, alreadyProcessed)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean supportsRepeatableWrites(Object object) {
        return true;
    }
}

