/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.codec.Encoder;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageEncoder;
import org.springframework.http.codec.protobuf.ProtobufEncoder;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ProtobufHttpMessageWriter
extends EncoderHttpMessageWriter<Message> {
    private static final String X_PROTOBUF_SCHEMA_HEADER = "X-Protobuf-Schema";
    private static final String X_PROTOBUF_MESSAGE_HEADER = "X-Protobuf-Message";
    private static final ConcurrentMap<Class<?>, Method> methodCache = new ConcurrentReferenceHashMap();

    public ProtobufHttpMessageWriter() {
        super(new ProtobufEncoder());
    }

    public ProtobufHttpMessageWriter(Encoder<Message> encoder) {
        super(encoder);
    }

    @Override
    public Mono<Void> write(Publisher<? extends Message> inputStream, ResolvableType elementType, @Nullable MediaType mediaType, ReactiveHttpOutputMessage message2, Map<String, Object> hints) {
        try {
            Message.Builder builder = ProtobufHttpMessageWriter.getMessageBuilder(elementType.toClass());
            Descriptors.Descriptor descriptor = builder.getDescriptorForType();
            message2.getHeaders().add(X_PROTOBUF_SCHEMA_HEADER, descriptor.getFile().getName());
            message2.getHeaders().add(X_PROTOBUF_MESSAGE_HEADER, descriptor.getFullName());
            if (inputStream instanceof Flux) {
                if (mediaType == null) {
                    message2.getHeaders().setContentType(((HttpMessageEncoder)this.getEncoder()).getStreamingMediaTypes().get(0));
                } else if (!"true".equals(mediaType.getParameters().get("delimited"))) {
                    HashMap<String, String> parameters2 = new HashMap<String, String>(mediaType.getParameters());
                    parameters2.put("delimited", "true");
                    message2.getHeaders().setContentType(new MediaType(mediaType.getType(), mediaType.getSubtype(), parameters2));
                }
            }
            return super.write(inputStream, elementType, mediaType, message2, hints);
        }
        catch (Exception ex) {
            return Mono.error((Throwable)new DecodingException("Could not read Protobuf message: " + ex.getMessage(), ex));
        }
    }

    private static Message.Builder getMessageBuilder(Class<?> clazz) throws Exception {
        Method method2 = (Method)methodCache.get(clazz);
        if (method2 == null) {
            method2 = clazz.getMethod("newBuilder", new Class[0]);
            methodCache.put(clazz, method2);
        }
        return (Message.Builder)method2.invoke(clazz, new Object[0]);
    }
}

