/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.multipart;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.codec.multipart.DefaultPartEvents;
import org.springframework.http.codec.multipart.PartEvent;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface FilePartEvent
extends PartEvent {
    default public String filename() {
        String filename2 = this.headers().getContentDisposition().getFilename();
        Assert.state(filename2 != null, "No filename found");
        return filename2;
    }

    public static Flux<FilePartEvent> create(String name2, Resource resource) {
        return FilePartEvent.create(name2, resource, null);
    }

    public static Flux<FilePartEvent> create(String name2, Resource resource, @Nullable Consumer<HttpHeaders> headersConsumer) {
        try {
            return FilePartEvent.create(name2, resource.getFile().toPath(), headersConsumer);
        }
        catch (IOException ex) {
            return Flux.error((Throwable)ex);
        }
    }

    public static Flux<FilePartEvent> create(String name2, Path path2) {
        return FilePartEvent.create(name2, path2, null);
    }

    public static Flux<FilePartEvent> create(String name2, Path path2, @Nullable Consumer<HttpHeaders> headersConsumer) {
        Assert.hasLength(name2, "Name must not be empty");
        Assert.notNull((Object)path2, "Path must not be null");
        return Flux.defer(() -> {
            String pathName = StringUtils.cleanPath(path2.toString());
            MediaType contentType = MediaTypeFactory.getMediaType(pathName).orElse(MediaType.APPLICATION_OCTET_STREAM);
            String filename2 = StringUtils.getFilename(pathName);
            if (filename2 == null) {
                return Flux.error((Throwable)new IllegalArgumentException("Invalid file: " + pathName));
            }
            Flux<DataBuffer> contents = DataBufferUtils.read(path2, DefaultDataBufferFactory.sharedInstance, 8192, new OpenOption[0]);
            return FilePartEvent.create(name2, filename2, contentType, contents, headersConsumer);
        });
    }

    public static Flux<FilePartEvent> create(String partName, String filename2, MediaType contentType, Flux<DataBuffer> contents) {
        return FilePartEvent.create(partName, filename2, contentType, contents, null);
    }

    public static Flux<FilePartEvent> create(String partName, String filename2, MediaType contentType, Flux<DataBuffer> contents, @Nullable Consumer<HttpHeaders> headersConsumer) {
        Assert.hasLength(partName, "PartName must not be empty");
        Assert.hasLength(filename2, "Filename must not be empty");
        Assert.notNull((Object)contentType, "ContentType must not be null");
        Assert.notNull(contents, "Contents must not be null");
        return Flux.defer(() -> {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(contentType);
            headers.setContentDisposition(ContentDisposition.formData().name(partName).filename(filename2, StandardCharsets.UTF_8).build());
            if (headersConsumer != null) {
                headersConsumer.accept(headers);
            }
            return contents.map(content -> DefaultPartEvents.file(headers, content, false)).concatWith((Publisher)Mono.just((Object)DefaultPartEvents.file(headers)));
        });
    }
}

