/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.multipart;

import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.codec.multipart.FilePartEvent;
import org.springframework.http.codec.multipart.FormPartEvent;
import org.springframework.http.codec.multipart.MultipartUtils;
import org.springframework.http.codec.multipart.PartEvent;
import org.springframework.util.Assert;

abstract class DefaultPartEvents {
    DefaultPartEvents() {
    }

    public static FormPartEvent form(HttpHeaders headers) {
        Assert.notNull((Object)headers, "Headers must not be null");
        return new DefaultFormFieldPartEvent(headers);
    }

    public static FormPartEvent form(HttpHeaders headers, String value2) {
        Assert.notNull((Object)headers, "Headers must not be null");
        Assert.notNull((Object)value2, "Value must not be null");
        return new DefaultFormFieldPartEvent(headers, value2);
    }

    public static FilePartEvent file(HttpHeaders headers, DataBuffer dataBuffer, boolean isLast) {
        Assert.notNull((Object)headers, "Headers must not be null");
        Assert.notNull((Object)dataBuffer, "DataBuffer must not be null");
        return new DefaultFilePartEvent(headers, dataBuffer, isLast);
    }

    public static FilePartEvent file(HttpHeaders headers) {
        Assert.notNull((Object)headers, "Headers must not be null");
        return new DefaultFilePartEvent(headers);
    }

    public static PartEvent create(HttpHeaders headers, DataBuffer dataBuffer, boolean isLast) {
        Assert.notNull((Object)headers, "Headers must not be null");
        Assert.notNull((Object)dataBuffer, "DataBuffer must not be null");
        if (headers.getContentDisposition().getFilename() != null) {
            return DefaultPartEvents.file(headers, dataBuffer, isLast);
        }
        return new DefaultPartEvent(headers, dataBuffer, isLast);
    }

    public static PartEvent create(HttpHeaders headers) {
        Assert.notNull((Object)headers, "Headers must not be null");
        if (headers.getContentDisposition().getFilename() != null) {
            return DefaultPartEvents.file(headers);
        }
        return new DefaultPartEvent(headers);
    }

    private static final class DefaultFormFieldPartEvent
    extends AbstractPartEvent
    implements FormPartEvent {
        private static final String EMPTY = "";
        private final String value;

        public DefaultFormFieldPartEvent(HttpHeaders headers) {
            this(headers, EMPTY);
        }

        public DefaultFormFieldPartEvent(HttpHeaders headers, String value2) {
            super(headers);
            this.value = value2;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public DataBuffer content() {
            byte[] bytes2 = this.value.getBytes(MultipartUtils.charset(this.headers()));
            return DefaultDataBufferFactory.sharedInstance.wrap(bytes2);
        }

        @Override
        public boolean isLast() {
            return true;
        }
    }

    private static class DefaultFilePartEvent
    extends DefaultPartEvent
    implements FilePartEvent {
        public DefaultFilePartEvent(HttpHeaders headers) {
            super(headers);
        }

        public DefaultFilePartEvent(HttpHeaders headers, DataBuffer content, boolean last2) {
            super(headers, content, last2);
        }
    }

    private static class DefaultPartEvent
    extends AbstractPartEvent {
        private static final DataBuffer EMPTY = DefaultDataBufferFactory.sharedInstance.allocateBuffer(0);
        private final DataBuffer content;
        private final boolean last;

        public DefaultPartEvent(HttpHeaders headers) {
            this(headers, EMPTY, true);
        }

        public DefaultPartEvent(HttpHeaders headers, DataBuffer content, boolean last2) {
            super(headers);
            this.content = content;
            this.last = last2;
        }

        @Override
        public DataBuffer content() {
            return this.content;
        }

        @Override
        public boolean isLast() {
            return this.last;
        }
    }

    private static abstract class AbstractPartEvent
    implements PartEvent {
        private final HttpHeaders headers;

        protected AbstractPartEvent(HttpHeaders headers) {
            this.headers = HttpHeaders.readOnlyHttpHeaders(headers);
        }

        @Override
        public HttpHeaders headers() {
            return this.headers;
        }
    }
}

