/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.async.ByteArrayFeeder;
import com.fasterxml.jackson.core.async.ByteBufferFeeder;
import com.fasterxml.jackson.core.async.NonBlockingInputFeeder;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferLimitException;
import org.springframework.core.io.buffer.DataBufferUtils;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

final class Jackson2Tokenizer {
    private final JsonParser parser;
    private final DeserializationContext deserializationContext;
    private final NonBlockingInputFeeder inputFeeder;
    private final boolean tokenizeArrayElements;
    private final boolean forceUseOfBigDecimal;
    private final int maxInMemorySize;
    private int objectDepth;
    private int arrayDepth;
    private int byteCount;
    private TokenBuffer tokenBuffer;

    private Jackson2Tokenizer(JsonParser parser, DeserializationContext deserializationContext, boolean tokenizeArrayElements, boolean forceUseOfBigDecimal, int maxInMemorySize) {
        this.parser = parser;
        this.deserializationContext = deserializationContext;
        this.inputFeeder = this.parser.getNonBlockingInputFeeder();
        this.tokenizeArrayElements = tokenizeArrayElements;
        this.forceUseOfBigDecimal = forceUseOfBigDecimal;
        this.maxInMemorySize = maxInMemorySize;
        this.tokenBuffer = this.createToken();
    }

    private List<TokenBuffer> tokenize(DataBuffer dataBuffer) {
        try {
            int bufferSize = dataBuffer.readableByteCount();
            ArrayList<TokenBuffer> tokens = new ArrayList<TokenBuffer>();
            NonBlockingInputFeeder nonBlockingInputFeeder = this.inputFeeder;
            if (nonBlockingInputFeeder instanceof ByteBufferFeeder) {
                ByteBufferFeeder byteBufferFeeder = (ByteBufferFeeder)nonBlockingInputFeeder;
                iterator = dataBuffer.readableByteBuffers();
                try {
                    while (iterator.hasNext()) {
                        byteBufferFeeder.feedInput((ByteBuffer)iterator.next());
                        this.parseTokens(tokens);
                    }
                }
                finally {
                    if (iterator != null) {
                        iterator.close();
                    }
                }
            } else {
                iterator = this.inputFeeder;
                if (iterator instanceof ByteArrayFeeder) {
                    ByteArrayFeeder byteArrayFeeder = (ByteArrayFeeder)iterator;
                    byte[] bytes2 = new byte[bufferSize];
                    dataBuffer.read(bytes2);
                    byteArrayFeeder.feedInput(bytes2, 0, bufferSize);
                    this.parseTokens(tokens);
                }
            }
            this.assertInMemorySize(bufferSize, tokens);
            ArrayList<TokenBuffer> arrayList = tokens;
            return arrayList;
        }
        catch (JsonProcessingException ex) {
            throw new DecodingException("JSON decoding error: " + ex.getOriginalMessage(), ex);
        }
        catch (IOException ex) {
            throw Exceptions.propagate((Throwable)ex);
        }
        finally {
            DataBufferUtils.release(dataBuffer);
        }
    }

    private Flux<TokenBuffer> endOfInput() {
        return Flux.defer(() -> {
            this.inputFeeder.endOfInput();
            try {
                ArrayList<TokenBuffer> tokens = new ArrayList<TokenBuffer>();
                this.parseTokens(tokens);
                return Flux.fromIterable(tokens);
            }
            catch (JsonProcessingException ex) {
                throw new DecodingException("JSON decoding error: " + ex.getOriginalMessage(), ex);
            }
            catch (IOException ex) {
                throw Exceptions.propagate((Throwable)ex);
            }
        });
    }

    private void parseTokens(List<TokenBuffer> tokens) throws IOException {
        JsonToken token2;
        boolean previousNull = false;
        while (!(this.parser.isClosed() || (token2 = this.parser.nextToken()) == JsonToken.NOT_AVAILABLE || token2 == null && previousNull)) {
            if (token2 == null) {
                previousNull = true;
                continue;
            }
            previousNull = false;
            this.updateDepth(token2);
            if (!this.tokenizeArrayElements) {
                this.processTokenNormal(token2, tokens);
                continue;
            }
            this.processTokenArray(token2, tokens);
        }
    }

    private void updateDepth(JsonToken token2) {
        switch (token2) {
            case START_OBJECT: {
                ++this.objectDepth;
                break;
            }
            case END_OBJECT: {
                --this.objectDepth;
                break;
            }
            case START_ARRAY: {
                ++this.arrayDepth;
                break;
            }
            case END_ARRAY: {
                --this.arrayDepth;
            }
        }
    }

    private void processTokenNormal(JsonToken token2, List<TokenBuffer> result2) throws IOException {
        this.tokenBuffer.copyCurrentEvent(this.parser);
        if ((token2.isStructEnd() || token2.isScalarValue()) && this.objectDepth == 0 && this.arrayDepth == 0) {
            result2.add(this.tokenBuffer);
            this.tokenBuffer = this.createToken();
        }
    }

    private void processTokenArray(JsonToken token2, List<TokenBuffer> result2) throws IOException {
        if (!this.isTopLevelArrayToken(token2)) {
            this.tokenBuffer.copyCurrentEvent(this.parser);
        }
        if (!(this.objectDepth != 0 || this.arrayDepth != 0 && this.arrayDepth != 1 || token2 != JsonToken.END_OBJECT && !token2.isScalarValue())) {
            result2.add(this.tokenBuffer);
            this.tokenBuffer = this.createToken();
        }
    }

    private TokenBuffer createToken() {
        TokenBuffer tokenBuffer = new TokenBuffer(this.parser, this.deserializationContext);
        tokenBuffer.forceUseOfBigDecimal(this.forceUseOfBigDecimal);
        return tokenBuffer;
    }

    private boolean isTopLevelArrayToken(JsonToken token2) {
        return this.objectDepth == 0 && (token2 == JsonToken.START_ARRAY && this.arrayDepth == 1 || token2 == JsonToken.END_ARRAY && this.arrayDepth == 0);
    }

    private void assertInMemorySize(int currentBufferSize, List<TokenBuffer> result2) {
        if (this.maxInMemorySize >= 0) {
            if (!result2.isEmpty()) {
                this.byteCount = 0;
            } else if (currentBufferSize > Integer.MAX_VALUE - this.byteCount) {
                this.raiseLimitException();
            } else {
                this.byteCount += currentBufferSize;
                if (this.byteCount > this.maxInMemorySize) {
                    this.raiseLimitException();
                }
            }
        }
    }

    private void raiseLimitException() {
        throw new DataBufferLimitException("Exceeded limit on max bytes per JSON object: " + this.maxInMemorySize);
    }

    public static Flux<TokenBuffer> tokenize(Flux<DataBuffer> dataBuffers, JsonFactory jsonFactory, ObjectMapper objectMapper, boolean tokenizeArrays, boolean forceUseOfBigDecimal, int maxInMemorySize) {
        try {
            JsonParser parser = jsonFactory.getFormatName().equals("Smile") ? jsonFactory.createNonBlockingByteArrayParser() : jsonFactory.createNonBlockingByteBufferParser();
            DeserializationContext context = objectMapper.getDeserializationContext();
            if (context instanceof DefaultDeserializationContext) {
                DefaultDeserializationContext ddc = (DefaultDeserializationContext)context;
                context = ddc.createInstance(objectMapper.getDeserializationConfig(), parser, objectMapper.getInjectableValues());
            }
            Jackson2Tokenizer tokenizer = new Jackson2Tokenizer(parser, context, tokenizeArrays, forceUseOfBigDecimal, maxInMemorySize);
            return dataBuffers.concatMapIterable(tokenizer::tokenize).concatWith(tokenizer.endOfInput());
        }
        catch (IOException ex) {
            return Flux.error((Throwable)ex);
        }
    }
}

