/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.CodecException;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.StringDecoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferLimitException;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServerSentEventHttpMessageReader
implements HttpMessageReader<Object> {
    private static final ResolvableType STRING_TYPE = ResolvableType.forClass(String.class);
    @Nullable
    private final Decoder<?> decoder;
    private final StringDecoder lineDecoder = StringDecoder.textPlainOnly();

    public ServerSentEventHttpMessageReader() {
        this(null);
    }

    public ServerSentEventHttpMessageReader(@Nullable Decoder<?> decoder) {
        this.decoder = decoder;
    }

    @Nullable
    public Decoder<?> getDecoder() {
        return this.decoder;
    }

    public void setMaxInMemorySize(int byteCount) {
        this.lineDecoder.setMaxInMemorySize(byteCount);
    }

    public int getMaxInMemorySize() {
        return this.lineDecoder.getMaxInMemorySize();
    }

    @Override
    public List<MediaType> getReadableMediaTypes() {
        return Collections.singletonList(MediaType.TEXT_EVENT_STREAM);
    }

    @Override
    public boolean canRead(ResolvableType elementType, @Nullable MediaType mediaType) {
        return MediaType.TEXT_EVENT_STREAM.includes(mediaType) || this.isServerSentEvent(elementType);
    }

    private boolean isServerSentEvent(ResolvableType elementType) {
        return ServerSentEvent.class.isAssignableFrom(elementType.toClass());
    }

    @Override
    public Flux<Object> read(ResolvableType elementType, ReactiveHttpInputMessage message2, Map<String, Object> hints) {
        LimitTracker limitTracker = new LimitTracker();
        boolean shouldWrap = this.isServerSentEvent(elementType);
        ResolvableType valueType = shouldWrap ? elementType.getGeneric(new int[0]) : elementType;
        return this.lineDecoder.decode((Publisher<DataBuffer>)message2.getBody(), STRING_TYPE, null, hints).doOnNext(limitTracker::afterLineParsed).bufferUntil(String::isEmpty).concatMap(lines2 -> {
            Object event2 = this.buildEvent((List<String>)lines2, valueType, shouldWrap, hints);
            return event2 != null ? Mono.just((Object)event2) : Mono.empty();
        });
    }

    @Nullable
    private Object buildEvent(List<String> lines2, ResolvableType valueType, boolean shouldWrap, Map<String, Object> hints) {
        Object decodedData;
        ServerSentEvent.Builder<Object> sseBuilder = shouldWrap ? ServerSentEvent.builder() : null;
        StringBuilder data2 = null;
        StringBuilder comment2 = null;
        for (String line : lines2) {
            if (line.startsWith("data:")) {
                int index2;
                int length2 = line.length();
                if (length2 <= 5 || length2 <= (index2 = line.charAt(5) != ' ' ? 5 : 6)) continue;
                data2 = data2 != null ? data2 : new StringBuilder();
                data2.append(line, index2, line.length());
                data2.append('\n');
                continue;
            }
            if (!shouldWrap) continue;
            if (line.startsWith("id:")) {
                sseBuilder.id(line.substring(3).trim());
                continue;
            }
            if (line.startsWith("event:")) {
                sseBuilder.event(line.substring(6).trim());
                continue;
            }
            if (line.startsWith("retry:")) {
                sseBuilder.retry(Duration.ofMillis(Long.parseLong(line.substring(6).trim())));
                continue;
            }
            if (!line.startsWith(":")) continue;
            comment2 = comment2 != null ? comment2 : new StringBuilder();
            comment2.append(line.substring(1).trim()).append('\n');
        }
        Object object = decodedData = data2 != null ? this.decodeData(data2, valueType, hints) : null;
        if (shouldWrap) {
            if (comment2 != null) {
                sseBuilder.comment(comment2.substring(0, comment2.length() - 1));
            }
            if (decodedData != null) {
                sseBuilder.data(decodedData);
            }
            return sseBuilder.build();
        }
        return decodedData;
    }

    @Nullable
    private Object decodeData(StringBuilder data2, ResolvableType dataType, Map<String, Object> hints) {
        if (String.class == dataType.resolve()) {
            return data2.substring(0, data2.length() - 1);
        }
        if (this.decoder == null) {
            throw new CodecException("No SSE decoder configured and the data is not String.");
        }
        byte[] bytes2 = data2.toString().getBytes(StandardCharsets.UTF_8);
        DefaultDataBuffer buffer = DefaultDataBufferFactory.sharedInstance.wrap(bytes2);
        return this.decoder.decode(buffer, dataType, (MimeType)MediaType.TEXT_EVENT_STREAM, hints);
    }

    @Override
    public Mono<Object> readMono(ResolvableType elementType, ReactiveHttpInputMessage message2, Map<String, Object> hints) {
        if (elementType.resolve() == String.class) {
            Flux<DataBuffer> body2 = message2.getBody();
            return this.lineDecoder.decodeToMono((Publisher<DataBuffer>)body2, elementType, null, null).cast(Object.class);
        }
        return Mono.error((Throwable)new UnsupportedOperationException("ServerSentEventHttpMessageReader only supports reading stream of events as a Flux"));
    }

    private class LimitTracker {
        private int accumulated = 0;

        private LimitTracker() {
        }

        public void afterLineParsed(String line) {
            if (ServerSentEventHttpMessageReader.this.getMaxInMemorySize() < 0) {
                return;
            }
            if (line.isEmpty()) {
                this.accumulated = 0;
            }
            if (line.length() > Integer.MAX_VALUE - this.accumulated) {
                this.raiseLimitException();
            } else {
                this.accumulated += line.length();
                if (this.accumulated > ServerSentEventHttpMessageReader.this.getMaxInMemorySize()) {
                    this.raiseLimitException();
                }
            }
        }

        private void raiseLimitException() {
            throw new DataBufferLimitException("Exceeded limit on max bytes to buffer : " + ServerSentEventHttpMessageReader.this.getMaxInMemorySize());
        }
    }
}

