/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractSingleValueEncoder;
import org.springframework.core.codec.Hints;
import org.springframework.core.codec.ResourceEncoder;
import org.springframework.core.codec.ResourceRegionEncoder;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.support.ResourceRegion;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpLogging;
import org.springframework.http.HttpRange;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.ZeroCopyHttpOutputMessage;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ResourceHttpMessageWriter
implements HttpMessageWriter<Resource> {
    private static final ResolvableType REGION_TYPE = ResolvableType.forClass(ResourceRegion.class);
    private static final Log logger = HttpLogging.forLogName(ResourceHttpMessageWriter.class);
    private final ResourceEncoder encoder;
    private final ResourceRegionEncoder regionEncoder;
    private final List<MediaType> mediaTypes;

    public ResourceHttpMessageWriter() {
        this(8192);
    }

    public ResourceHttpMessageWriter(int bufferSize) {
        this.encoder = new ResourceEncoder(bufferSize);
        this.regionEncoder = new ResourceRegionEncoder(bufferSize);
        this.mediaTypes = MediaType.asMediaTypes(this.encoder.getEncodableMimeTypes());
    }

    @Override
    public boolean canWrite(ResolvableType elementType, @Nullable MediaType mediaType) {
        return this.encoder.canEncode(elementType, mediaType);
    }

    @Override
    public List<MediaType> getWritableMediaTypes() {
        return this.mediaTypes;
    }

    @Override
    public Mono<Void> write(Publisher<? extends Resource> inputStream, ResolvableType elementType, @Nullable MediaType mediaType, ReactiveHttpOutputMessage message2, Map<String, Object> hints) {
        return Mono.from(inputStream).flatMap(resource -> this.writeResource((Resource)resource, elementType, mediaType, message2, hints));
    }

    private Mono<Void> writeResource(Resource resource, ResolvableType type2, @Nullable MediaType mediaType, ReactiveHttpOutputMessage message2, Map<String, Object> hints) {
        return this.addDefaultHeaders(message2, resource, mediaType, hints).then(Mono.defer(() -> {
            Mono<Void> result2 = ResourceHttpMessageWriter.zeroCopy(resource, null, message2, hints);
            if (result2 != null) {
                return result2;
            }
            Mono input = Mono.just((Object)resource);
            DataBufferFactory factory = message2.bufferFactory();
            Flux body2 = ((AbstractSingleValueEncoder)this.encoder).encode(input, factory, type2, (MimeType)message2.getHeaders().getContentType(), hints).subscribeOn(Schedulers.boundedElastic());
            if (logger.isDebugEnabled()) {
                body2 = body2.doOnNext(buffer -> Hints.touchDataBuffer(buffer, hints, logger));
            }
            return message2.writeWith((Publisher<? extends DataBuffer>)body2);
        }));
    }

    @Deprecated(since="6.1", forRemoval=true)
    public void addHeaders(ReactiveHttpOutputMessage message2, Resource resource, @Nullable MediaType contentType, Map<String, Object> hints) {
        this.addDefaultHeaders(message2, resource, contentType, hints).block();
    }

    public Mono<Void> addDefaultHeaders(ReactiveHttpOutputMessage message2, Resource resource, @Nullable MediaType contentType, Map<String, Object> hints) {
        return Mono.defer(() -> {
            HttpHeaders headers = message2.getHeaders();
            MediaType resourceMediaType = ResourceHttpMessageWriter.getResourceMediaType(contentType, resource, hints);
            headers.setContentType(resourceMediaType);
            if (message2 instanceof ServerHttpResponse) {
                headers.set("Accept-Ranges", "bytes");
            }
            if (headers.getContentLength() < 0L) {
                return ResourceHttpMessageWriter.lengthOf(resource).flatMap(contentLength -> {
                    headers.setContentLength((long)contentLength);
                    return Mono.empty();
                });
            }
            return Mono.empty();
        });
    }

    private static MediaType getResourceMediaType(@Nullable MediaType mediaType, Resource resource, Map<String, Object> hints) {
        if (mediaType != null && mediaType.isConcrete() && !mediaType.equals(MediaType.APPLICATION_OCTET_STREAM)) {
            return mediaType;
        }
        mediaType = MediaTypeFactory.getMediaType(resource).orElse(MediaType.APPLICATION_OCTET_STREAM);
        if (logger.isDebugEnabled() && !Hints.isLoggingSuppressed(hints)) {
            logger.debug(Hints.getLogPrefix(hints) + "Resource associated with '" + mediaType + "'");
        }
        return mediaType;
    }

    private static Mono<Long> lengthOf(Resource resource) {
        if (InputStreamResource.class != resource.getClass()) {
            return Mono.fromCallable(resource::contentLength).filter(length2 -> length2 != -1L).onErrorComplete(IOException.class).subscribeOn(Schedulers.boundedElastic());
        }
        return Mono.empty();
    }

    @Nullable
    private static Mono<Void> zeroCopy(Resource resource, @Nullable ResourceRegion region, ReactiveHttpOutputMessage message2, Map<String, Object> hints) {
        if (message2 instanceof ZeroCopyHttpOutputMessage) {
            ZeroCopyHttpOutputMessage zeroCopyHttpOutputMessage = (ZeroCopyHttpOutputMessage)message2;
            if (resource.isFile()) {
                try {
                    long count2;
                    File file2 = resource.getFile();
                    long pos2 = region != null ? region.getPosition() : 0L;
                    long l = count2 = region != null ? region.getCount() : file2.length();
                    if (logger.isDebugEnabled()) {
                        String formatted = region != null ? "region " + pos2 + "-" + count2 + " of " : "";
                        logger.debug(Hints.getLogPrefix(hints) + "Zero-copy " + formatted + "[" + resource + "]");
                    }
                    return zeroCopyHttpOutputMessage.writeWith(file2, pos2, count2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    public Mono<Void> write(Publisher<? extends Resource> inputStream, @Nullable ResolvableType actualType, ResolvableType elementType, @Nullable MediaType mediaType, ServerHttpRequest request, ServerHttpResponse response, Map<String, Object> hints) {
        List<HttpRange> ranges;
        HttpHeaders headers = response.getHeaders();
        headers.set("Accept-Ranges", "bytes");
        try {
            ranges = request.getHeaders().getRange();
        }
        catch (IllegalArgumentException ex) {
            response.setStatusCode(HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE);
            return response.setComplete();
        }
        return Mono.from(inputStream).flatMap(resource -> {
            if (ranges.isEmpty()) {
                return this.writeResource((Resource)resource, elementType, mediaType, response, hints);
            }
            response.setStatusCode(HttpStatus.PARTIAL_CONTENT);
            List<ResourceRegion> regions = HttpRange.toResourceRegions(ranges, resource);
            MediaType resourceMediaType = ResourceHttpMessageWriter.getResourceMediaType(mediaType, resource, hints);
            if (regions.size() == 1) {
                ResourceRegion region = regions.get(0);
                headers.setContentType(resourceMediaType);
                return ResourceHttpMessageWriter.lengthOf(resource).flatMap(contentLength -> {
                    long start2 = region.getPosition();
                    long end2 = start2 + region.getCount() - 1L;
                    end2 = Math.min(end2, contentLength - 1L);
                    headers.add("Content-Range", "bytes " + start2 + "-" + end2 + "/" + contentLength);
                    headers.setContentLength(end2 - start2 + 1L);
                    return Mono.empty();
                }).then(this.writeSingleRegion(region, response, hints));
            }
            String boundary = MimeTypeUtils.generateMultipartBoundaryString();
            MediaType multipartType = MediaType.parseMediaType("multipart/byteranges;boundary=" + boundary);
            headers.setContentType(multipartType);
            Map<String, Object> allHints = Hints.merge(hints, ResourceRegionEncoder.BOUNDARY_STRING_HINT, boundary);
            return this.encodeAndWriteRegions((Publisher<? extends ResourceRegion>)Flux.fromIterable(regions), resourceMediaType, response, allHints);
        });
    }

    private Mono<Void> writeSingleRegion(ResourceRegion region, ReactiveHttpOutputMessage message2, Map<String, Object> hints) {
        Mono<Void> result2 = ResourceHttpMessageWriter.zeroCopy(region.getResource(), region, message2, hints);
        if (result2 != null) {
            return result2;
        }
        Mono input = Mono.just((Object)region);
        MediaType mediaType = message2.getHeaders().getContentType();
        return this.encodeAndWriteRegions((Publisher<? extends ResourceRegion>)input, mediaType, message2, hints);
    }

    private Mono<Void> encodeAndWriteRegions(Publisher<? extends ResourceRegion> publisher, @Nullable MediaType mediaType, ReactiveHttpOutputMessage message2, Map<String, Object> hints) {
        Flux body2 = this.regionEncoder.encode(publisher, message2.bufferFactory(), REGION_TYPE, (MimeType)mediaType, hints).subscribeOn(Schedulers.boundedElastic());
        return message2.writeWith((Publisher<? extends DataBuffer>)body2);
    }
}

