/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.text.Charsets;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.StringFormat;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.CharSequenceEncoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.codec.EncodingException;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.codec.KotlinSerializationSupport;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class KotlinSerializationStringEncoder<T extends StringFormat>
extends KotlinSerializationSupport<T>
implements Encoder<Object> {
    private final CharSequenceEncoder charSequenceEncoder = CharSequenceEncoder.allMimeTypes();
    private final Set<MimeType> streamingMediaTypes = new HashSet<MimeType>();

    protected KotlinSerializationStringEncoder(T format, MimeType ... supportedMimeTypes) {
        super(format, supportedMimeTypes);
    }

    public void setStreamingMediaTypes(Collection<MediaType> streamingMediaTypes) {
        this.streamingMediaTypes.clear();
        this.streamingMediaTypes.addAll(streamingMediaTypes);
    }

    @Override
    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return this.canSerialize(elementType, mimeType);
    }

    @Override
    public List<MimeType> getEncodableMimeTypes() {
        return this.supportedMimeTypes();
    }

    @Override
    public List<MimeType> getEncodableMimeTypes(ResolvableType elementType) {
        return this.supportedMimeTypes();
    }

    @Override
    public Flux<DataBuffer> encode(Publisher<?> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        if (inputStream instanceof Mono) {
            return Mono.from(inputStream).map(value2 -> this.encodeValue(value2, bufferFactory, elementType, mimeType, hints)).flux();
        }
        if (mimeType != null && this.streamingMediaTypes.contains(mimeType)) {
            return Flux.from(inputStream).map(list2 -> this.encodeValue(list2, bufferFactory, elementType, mimeType, hints).write("\n", Charsets.UTF_8));
        }
        ResolvableType listType = ResolvableType.forClassWithGenerics(List.class, elementType);
        return Flux.from(inputStream).collectList().map(list2 -> this.encodeValue(list2, bufferFactory, listType, mimeType, hints)).flux();
    }

    @Override
    public DataBuffer encodeValue(Object value2, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        KSerializer<Object> serializer = this.serializer(valueType);
        if (serializer == null) {
            throw new EncodingException("Could not find KSerializer for " + valueType);
        }
        String string2 = ((StringFormat)this.format()).encodeToString(serializer, value2);
        return this.charSequenceEncoder.encodeValue(string2, bufferFactory, valueType, mimeType, (Map<String, Object>)null);
    }
}

