/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractEncoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpLogging;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageEncoder;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class EncoderHttpMessageWriter<T>
implements HttpMessageWriter<T> {
    private static final Log logger = HttpLogging.forLogName(EncoderHttpMessageWriter.class);
    private final Encoder<T> encoder;
    private final List<MediaType> mediaTypes;
    @Nullable
    private final MediaType defaultMediaType;

    public EncoderHttpMessageWriter(Encoder<T> encoder) {
        Assert.notNull(encoder, "Encoder is required");
        EncoderHttpMessageWriter.initLogger(encoder);
        this.encoder = encoder;
        this.mediaTypes = MediaType.asMediaTypes(encoder.getEncodableMimeTypes());
        this.defaultMediaType = EncoderHttpMessageWriter.initDefaultMediaType(this.mediaTypes);
    }

    private static void initLogger(Encoder<?> encoder) {
        if (encoder instanceof AbstractEncoder) {
            AbstractEncoder abstractEncoder = (AbstractEncoder)encoder;
            if (encoder.getClass().getName().startsWith("org.springframework.core.codec")) {
                Log logger = HttpLogging.forLog(abstractEncoder.getLogger());
                abstractEncoder.setLogger(logger);
            }
        }
    }

    @Nullable
    private static MediaType initDefaultMediaType(List<MediaType> mediaTypes) {
        return mediaTypes.stream().filter(MimeType::isConcrete).findFirst().orElse(null);
    }

    public Encoder<T> getEncoder() {
        return this.encoder;
    }

    @Override
    public List<MediaType> getWritableMediaTypes() {
        return this.mediaTypes;
    }

    @Override
    public List<MediaType> getWritableMediaTypes(ResolvableType elementType) {
        return MediaType.asMediaTypes(this.getEncoder().getEncodableMimeTypes(elementType));
    }

    @Override
    public boolean canWrite(ResolvableType elementType, @Nullable MediaType mediaType) {
        return this.encoder.canEncode(elementType, mediaType);
    }

    @Override
    public Mono<Void> write(Publisher<? extends T> inputStream, ResolvableType elementType, @Nullable MediaType mediaType, ReactiveHttpOutputMessage message2, Map<String, Object> hints) {
        MediaType contentType = this.updateContentType(message2, mediaType);
        Flux body2 = this.encoder.encode(inputStream, message2.bufferFactory(), elementType, contentType, hints);
        if (inputStream instanceof Mono) {
            return body2.singleOrEmpty().switchIfEmpty(Mono.defer(() -> {
                message2.getHeaders().setContentLength(0L);
                return message2.setComplete().then(Mono.empty());
            })).flatMap(buffer -> {
                Hints.touchDataBuffer(buffer, hints, logger);
                message2.getHeaders().setContentLength(buffer.readableByteCount());
                return message2.writeWith((Publisher<? extends DataBuffer>)Mono.just((Object)buffer).doOnDiscard(DataBuffer.class, DataBufferUtils::release));
            }).doOnDiscard(DataBuffer.class, DataBufferUtils::release);
        }
        if (this.isStreamingMediaType(contentType)) {
            return message2.writeAndFlushWith((Publisher<? extends Publisher<? extends DataBuffer>>)body2.map(buffer -> {
                Hints.touchDataBuffer(buffer, hints, logger);
                return Mono.just((Object)buffer).doOnDiscard(DataBuffer.class, DataBufferUtils::release);
            }));
        }
        if (logger.isDebugEnabled()) {
            body2 = body2.doOnNext(buffer -> Hints.touchDataBuffer(buffer, hints, logger));
        }
        return message2.writeWith((Publisher<? extends DataBuffer>)body2);
    }

    @Nullable
    private MediaType updateContentType(ReactiveHttpOutputMessage message2, @Nullable MediaType mediaType) {
        MediaType result2 = message2.getHeaders().getContentType();
        if (result2 != null) {
            return result2;
        }
        MediaType fallback = this.defaultMediaType;
        MediaType mediaType2 = result2 = EncoderHttpMessageWriter.useFallback(mediaType, fallback) ? fallback : mediaType;
        if (result2 != null) {
            result2 = EncoderHttpMessageWriter.addDefaultCharset(result2, fallback);
            message2.getHeaders().setContentType(result2);
        }
        return result2;
    }

    private static boolean useFallback(@Nullable MediaType main2, @Nullable MediaType fallback) {
        return main2 == null || !main2.isConcrete() || main2.equals(MediaType.APPLICATION_OCTET_STREAM) && fallback != null;
    }

    private static MediaType addDefaultCharset(MediaType main2, @Nullable MediaType defaultType) {
        if (main2.getCharset() == null && defaultType != null && defaultType.getCharset() != null) {
            return new MediaType(main2, defaultType.getCharset());
        }
        return main2;
    }

    private boolean isStreamingMediaType(@Nullable MediaType mediaType) {
        Object object;
        if (mediaType == null || !((object = this.encoder) instanceof HttpMessageEncoder)) {
            return false;
        }
        HttpMessageEncoder httpMessageEncoder = (HttpMessageEncoder)object;
        for (MediaType streamingMediaType : httpMessageEncoder.getStreamingMediaTypes()) {
            if (!mediaType.isCompatibleWith(streamingMediaType) || !this.matchParameters(mediaType, streamingMediaType)) continue;
            return true;
        }
        return false;
    }

    private boolean matchParameters(MediaType streamingMediaType, MediaType mediaType) {
        for (String name2 : streamingMediaType.getParameters().keySet()) {
            String s1 = streamingMediaType.getParameter(name2);
            String s2 = mediaType.getParameter(name2);
            if (!StringUtils.hasText(s1) || !StringUtils.hasText(s2) || s1.equalsIgnoreCase(s2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Mono<Void> write(Publisher<? extends T> inputStream, ResolvableType actualType, ResolvableType elementType, @Nullable MediaType mediaType, ServerHttpRequest request, ServerHttpResponse response, Map<String, Object> hints) {
        Map<String, Object> allHints = Hints.merge(hints, this.getWriteHints(actualType, elementType, mediaType, request, response));
        return this.write(inputStream, elementType, mediaType, response, allHints);
    }

    protected Map<String, Object> getWriteHints(ResolvableType streamType, ResolvableType elementType, @Nullable MediaType mediaType, ServerHttpRequest request, ServerHttpResponse response) {
        Encoder<T> encoder = this.encoder;
        if (encoder instanceof HttpMessageEncoder) {
            HttpMessageEncoder httpMessageEncoder = (HttpMessageEncoder)encoder;
            return httpMessageEncoder.getEncodeHints(streamType, elementType, mediaType, request, response);
        }
        return Hints.none();
    }
}

