/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.util.ClassUtils;

final class CodecConfigurerFactory {
    private static final String DEFAULT_CONFIGURERS_PATH = "CodecConfigurer.properties";
    private static final Map<Class<?>, Class<?>> defaultCodecConfigurers = new HashMap(4);

    private CodecConfigurerFactory() {
    }

    public static <T extends CodecConfigurer> T create(Class<T> ifc) {
        Class<?> impl2 = defaultCodecConfigurers.get(ifc);
        if (impl2 == null) {
            throw new IllegalStateException("No default codec configurer found for " + ifc);
        }
        return (T)((CodecConfigurer)BeanUtils.instantiateClass(impl2));
    }

    static {
        try {
            Properties props = PropertiesLoaderUtils.loadProperties(new ClassPathResource(DEFAULT_CONFIGURERS_PATH, CodecConfigurerFactory.class));
            for (String ifcName : props.stringPropertyNames()) {
                String implName = props.getProperty(ifcName);
                Class<?> ifc = ClassUtils.forName(ifcName, CodecConfigurerFactory.class.getClassLoader());
                Class<?> impl2 = ClassUtils.forName(implName, CodecConfigurerFactory.class.getClassLoader());
                defaultCodecConfigurers.put(ifc, impl2);
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

