/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.AbstractClientHttpRequest;
import org.springframework.http.support.JettyHeadersAdapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

class JettyClientHttpRequest
extends AbstractClientHttpRequest {
    private final Request jettyRequest;
    private final DataBufferFactory bufferFactory;
    private final ReactiveRequest.Builder builder;

    public JettyClientHttpRequest(Request jettyRequest, DataBufferFactory bufferFactory) {
        this.jettyRequest = jettyRequest;
        this.bufferFactory = bufferFactory;
        this.builder = ReactiveRequest.newBuilder((Request)this.jettyRequest).abortOnCancel(true);
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.jettyRequest.getMethod());
    }

    @Override
    public URI getURI() {
        return this.jettyRequest.getURI();
    }

    @Override
    public Mono<Void> setComplete() {
        return this.doCommit();
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.jettyRequest;
    }

    @Override
    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body2) {
        return Mono.create(sink -> {
            ReactiveRequest.Content content = (ReactiveRequest.Content)Flux.from((Publisher)body2).concatMapIterable(this::toContentChunks).concatWith((Publisher)Mono.just((Object)Content.Chunk.EOF)).doOnError(arg_0 -> ((MonoSink)sink).error(arg_0)).as(chunks -> ReactiveRequest.Content.fromPublisher((Publisher)chunks, (String)this.getContentType()));
            this.builder.content(content);
            sink.success();
        }).then(this.doCommit());
    }

    @Override
    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body2) {
        return this.writeWith((Publisher<? extends DataBuffer>)Flux.from(body2).flatMap(Function.identity()).doOnDiscard(DataBuffer.class, DataBufferUtils::release));
    }

    private String getContentType() {
        MediaType contentType = this.getHeaders().getContentType();
        return contentType != null ? contentType.toString() : "application/octet-stream";
    }

    private List<Content.Chunk> toContentChunks(DataBuffer dataBuffer) {
        ArrayList<Content.Chunk> result2 = new ArrayList<Content.Chunk>(1);
        DataBuffer.ByteBufferIterator iterator = dataBuffer.readableByteBuffers();
        while (iterator.hasNext()) {
            ByteBuffer byteBuffer = (ByteBuffer)iterator.next();
            boolean last2 = !iterator.hasNext();
            Content.Chunk chunk2 = Content.Chunk.from((ByteBuffer)byteBuffer, (boolean)false, () -> {
                if (last2) {
                    iterator.close();
                    DataBufferUtils.release(dataBuffer);
                }
            });
            result2.add(chunk2);
        }
        return result2;
    }

    @Override
    protected void applyCookies() {
        this.getCookies().values().stream().flatMap(Collection::stream).map(cookie -> HttpCookie.build((String)cookie.getName(), (String)cookie.getValue()).build()).forEach(arg_0 -> ((Request)this.jettyRequest).cookie(arg_0));
    }

    @Override
    protected void applyHeaders() {
        HttpHeaders headers = this.getHeaders();
        this.jettyRequest.headers(fields2 -> {
            headers.forEach((BiConsumer<? super String, ? super List<String>>)((BiConsumer<String, List>)(key2, value2) -> value2.forEach(v -> fields2.add(key2, v))));
            if (!headers.containsKey("Accept")) {
                fields2.add("Accept", "*/*");
            }
        });
    }

    @Override
    protected HttpHeaders initReadOnlyHeaders() {
        return HttpHeaders.readOnlyHttpHeaders(new JettyHeadersAdapter(this.jettyRequest.getHeaders()));
    }

    public ReactiveRequest toReactiveRequest() {
        return this.builder.build();
    }
}

