/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.core.io.buffer.TouchableDataBuffer;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.client.reactive.JettyClientHttpRequest;
import org.springframework.http.client.reactive.JettyClientHttpResponse;
import org.springframework.http.client.reactive.JettyResourceFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JettyClientHttpConnector
implements ClientHttpConnector {
    private final HttpClient httpClient;
    private DataBufferFactory bufferFactory = DefaultDataBufferFactory.sharedInstance;

    public JettyClientHttpConnector() {
        this(new HttpClient());
    }

    public JettyClientHttpConnector(HttpClient httpClient) {
        this(httpClient, null);
    }

    public JettyClientHttpConnector(HttpClient httpClient, @Nullable JettyResourceFactory resourceFactory) {
        Assert.notNull((Object)httpClient, "HttpClient is required");
        if (resourceFactory != null) {
            httpClient.setExecutor(resourceFactory.getExecutor());
            httpClient.setByteBufferPool(resourceFactory.getByteBufferPool());
            httpClient.setScheduler(resourceFactory.getScheduler());
        }
        this.httpClient = httpClient;
    }

    @Deprecated
    public JettyClientHttpConnector(JettyResourceFactory resourceFactory, @Nullable Consumer<HttpClient> customizer2) {
        this(new HttpClient(), resourceFactory);
        if (customizer2 != null) {
            customizer2.accept(this.httpClient);
        }
    }

    public void setBufferFactory(DataBufferFactory bufferFactory) {
        this.bufferFactory = bufferFactory;
    }

    @Override
    public Mono<ClientHttpResponse> connect(HttpMethod method2, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        if (!uri.isAbsolute()) {
            return Mono.error((Throwable)new IllegalArgumentException("URI is not absolute: " + uri));
        }
        if (!this.httpClient.isStarted()) {
            try {
                this.httpClient.start();
            }
            catch (Exception ex) {
                return Mono.error((Throwable)ex);
            }
        }
        Request jettyRequest = this.httpClient.newRequest(uri).method(method2.toString());
        JettyClientHttpRequest request = new JettyClientHttpRequest(jettyRequest, this.bufferFactory);
        return requestCallback.apply(request).then(this.execute(request));
    }

    private Mono<ClientHttpResponse> execute(JettyClientHttpRequest request) {
        return Mono.fromDirect((Publisher)request.toReactiveRequest().response((reactiveResponse, chunkPublisher) -> {
            Flux content = Flux.from((Publisher)chunkPublisher).map(this::toDataBuffer);
            return Mono.just((Object)new JettyClientHttpResponse((ReactiveResponse)reactiveResponse, (Flux<DataBuffer>)content));
        }));
    }

    private DataBuffer toDataBuffer(Content.Chunk chunk2) {
        DataBuffer delegate = this.bufferFactory.wrap(chunk2.getByteBuffer());
        return new JettyDataBuffer(delegate, chunk2);
    }

    private static final class JettyDataBuffer
    implements PooledDataBuffer {
        private final DataBuffer delegate;
        private final Content.Chunk chunk;
        private final AtomicInteger refCount = new AtomicInteger(1);

        public JettyDataBuffer(DataBuffer delegate, Content.Chunk chunk2) {
            Assert.notNull((Object)delegate, "Delegate must not be null");
            Assert.notNull((Object)chunk2, "Chunk must not be null");
            this.delegate = delegate;
            this.chunk = chunk2;
        }

        @Override
        public boolean isAllocated() {
            return this.refCount.get() > 0;
        }

        @Override
        public PooledDataBuffer retain() {
            DataBuffer dataBuffer = this.delegate;
            if (dataBuffer instanceof PooledDataBuffer) {
                PooledDataBuffer pooledDelegate = (PooledDataBuffer)dataBuffer;
                pooledDelegate.retain();
            }
            this.chunk.retain();
            this.refCount.getAndUpdate(c -> {
                if (c != 0) {
                    return c + 1;
                }
                return 0;
            });
            return this;
        }

        @Override
        public boolean release() {
            DataBuffer dataBuffer = this.delegate;
            if (dataBuffer instanceof PooledDataBuffer) {
                PooledDataBuffer pooledDelegate = (PooledDataBuffer)dataBuffer;
                pooledDelegate.release();
            }
            this.chunk.release();
            int refCount = this.refCount.updateAndGet(c -> {
                if (c != 0) {
                    return c - 1;
                }
                throw new IllegalStateException("already released " + this);
            });
            return refCount == 0;
        }

        @Override
        public PooledDataBuffer touch(Object hint) {
            DataBuffer dataBuffer = this.delegate;
            if (dataBuffer instanceof TouchableDataBuffer) {
                TouchableDataBuffer touchableDelegate = (TouchableDataBuffer)dataBuffer;
                touchableDelegate.touch(hint);
            }
            return this;
        }

        @Override
        public DataBufferFactory factory() {
            return this.delegate.factory();
        }

        @Override
        public int indexOf(IntPredicate predicate, int fromIndex) {
            return this.delegate.indexOf(predicate, fromIndex);
        }

        @Override
        public int lastIndexOf(IntPredicate predicate, int fromIndex) {
            return this.delegate.lastIndexOf(predicate, fromIndex);
        }

        @Override
        public int readableByteCount() {
            return this.delegate.readableByteCount();
        }

        @Override
        public int writableByteCount() {
            return this.delegate.writableByteCount();
        }

        @Override
        public int capacity() {
            return this.delegate.capacity();
        }

        @Override
        @Deprecated
        public DataBuffer capacity(int capacity) {
            this.delegate.capacity(capacity);
            return this;
        }

        @Override
        public DataBuffer ensureWritable(int capacity) {
            this.delegate.ensureWritable(capacity);
            return this;
        }

        @Override
        public int readPosition() {
            return this.delegate.readPosition();
        }

        @Override
        public DataBuffer readPosition(int readPosition) {
            this.delegate.readPosition(readPosition);
            return this;
        }

        @Override
        public int writePosition() {
            return this.delegate.writePosition();
        }

        @Override
        public DataBuffer writePosition(int writePosition) {
            this.delegate.writePosition(writePosition);
            return this;
        }

        @Override
        public byte getByte(int index2) {
            return this.delegate.getByte(index2);
        }

        @Override
        public byte read() {
            return this.delegate.read();
        }

        @Override
        public DataBuffer read(byte[] destination) {
            this.delegate.read(destination);
            return this;
        }

        @Override
        public DataBuffer read(byte[] destination, int offset2, int length2) {
            this.delegate.read(destination, offset2, length2);
            return this;
        }

        @Override
        public DataBuffer write(byte b2) {
            this.delegate.write(b2);
            return this;
        }

        @Override
        public DataBuffer write(byte[] source2) {
            this.delegate.write(source2);
            return this;
        }

        @Override
        public DataBuffer write(byte[] source2, int offset2, int length2) {
            this.delegate.write(source2, offset2, length2);
            return this;
        }

        @Override
        public DataBuffer write(DataBuffer ... buffers) {
            this.delegate.write(buffers);
            return this;
        }

        @Override
        public DataBuffer write(ByteBuffer ... buffers) {
            this.delegate.write(buffers);
            return this;
        }

        @Override
        @Deprecated
        public DataBuffer slice(int index2, int length2) {
            DataBuffer delegateSlice = this.delegate.slice(index2, length2);
            this.chunk.retain();
            return new JettyDataBuffer(delegateSlice, this.chunk);
        }

        @Override
        public DataBuffer split(int index2) {
            DataBuffer delegateSplit = this.delegate.split(index2);
            this.chunk.retain();
            return new JettyDataBuffer(delegateSplit, this.chunk);
        }

        @Override
        @Deprecated
        public ByteBuffer asByteBuffer() {
            return this.delegate.asByteBuffer();
        }

        @Override
        @Deprecated
        public ByteBuffer asByteBuffer(int index2, int length2) {
            return this.delegate.asByteBuffer(index2, length2);
        }

        @Override
        @Deprecated
        public ByteBuffer toByteBuffer(int index2, int length2) {
            return this.delegate.toByteBuffer(index2, length2);
        }

        @Override
        public void toByteBuffer(int srcPos, ByteBuffer dest, int destPos, int length2) {
            this.delegate.toByteBuffer(srcPos, dest, destPos, length2);
        }

        @Override
        public DataBuffer.ByteBufferIterator readableByteBuffers() {
            DataBuffer.ByteBufferIterator delegateIterator = this.delegate.readableByteBuffers();
            return new JettyByteBufferIterator(delegateIterator, this.chunk);
        }

        @Override
        public DataBuffer.ByteBufferIterator writableByteBuffers() {
            DataBuffer.ByteBufferIterator delegateIterator = this.delegate.writableByteBuffers();
            return new JettyByteBufferIterator(delegateIterator, this.chunk);
        }

        @Override
        public String toString(int index2, int length2, Charset charset) {
            return this.delegate.toString(index2, length2, charset);
        }

        private static final class JettyByteBufferIterator
        implements DataBuffer.ByteBufferIterator {
            private final DataBuffer.ByteBufferIterator delegate;
            private final Content.Chunk chunk;

            public JettyByteBufferIterator(DataBuffer.ByteBufferIterator delegate, Content.Chunk chunk2) {
                Assert.notNull((Object)delegate, "Delegate must not be null");
                Assert.notNull((Object)chunk2, "Chunk must not be null");
                this.delegate = delegate;
                this.chunk = chunk2;
                this.chunk.retain();
            }

            @Override
            public void close() {
                this.delegate.close();
                this.chunk.release();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public ByteBuffer next() {
                return (ByteBuffer)this.delegate.next();
            }
        }
    }
}

