/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.nio.ByteBuffer;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.AbstractClientHttpResponse;
import org.springframework.http.support.HttpComponentsHeadersAdapter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;

class HttpComponentsClientHttpResponse
extends AbstractClientHttpResponse {
    public HttpComponentsClientHttpResponse(DataBufferFactory dataBufferFactory, Message<HttpResponse, Publisher<ByteBuffer>> message2, HttpClientContext context) {
        super(HttpStatusCode.valueOf(((HttpResponse)message2.getHead()).getCode()), HttpHeaders.readOnlyHttpHeaders(new HttpComponentsHeadersAdapter((HttpMessage)message2.getHead())), HttpComponentsClientHttpResponse.adaptCookies(context), (Flux<DataBuffer>)Flux.from((Publisher)((Publisher)message2.getBody())).map(dataBufferFactory::wrap));
    }

    private static MultiValueMap<String, ResponseCookie> adaptCookies(HttpClientContext context) {
        LinkedMultiValueMap<String, ResponseCookie> result2 = new LinkedMultiValueMap<String, ResponseCookie>();
        context.getCookieStore().getCookies().forEach(cookie -> result2.add(cookie.getName(), ResponseCookie.fromClientResponse(cookie.getName(), cookie.getValue()).domain(cookie.getDomain()).path(cookie.getPath()).maxAge(HttpComponentsClientHttpResponse.getMaxAgeSeconds(cookie)).secure(cookie.isSecure()).httpOnly(cookie.containsAttribute("httponly")).sameSite(cookie.getAttribute("samesite")).build()));
        return result2;
    }

    private static long getMaxAgeSeconds(Cookie cookie) {
        String maxAgeAttribute = cookie.getAttribute("max-age");
        return maxAgeAttribute != null ? Long.parseLong(maxAgeAttribute) : -1L;
    }
}

