/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.AbstractStreamingClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.OutputStreamPublisher;
import org.springframework.http.client.ReactorNettyClientResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.NettyOutbound;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;

final class ReactorNettyClientRequest
extends AbstractStreamingClientHttpRequest {
    private final HttpClient httpClient;
    private final HttpMethod method;
    private final URI uri;
    private final Duration exchangeTimeout;
    private final Duration readTimeout;

    public ReactorNettyClientRequest(HttpClient httpClient, URI uri, HttpMethod method2, Duration exchangeTimeout, Duration readTimeout) {
        this.httpClient = httpClient;
        this.method = method2;
        this.uri = uri;
        this.exchangeTimeout = exchangeTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers, @Nullable StreamingHttpOutputMessage.Body body2) throws IOException {
        HttpClient.RequestSender requestSender = this.httpClient.request(io.netty.handler.codec.http.HttpMethod.valueOf((String)this.method.name()));
        requestSender = this.uri.isAbsolute() ? (HttpClient.RequestSender)requestSender.uri(this.uri) : (HttpClient.RequestSender)requestSender.uri(this.uri.toString());
        try {
            ReactorNettyClientResponse result2 = (ReactorNettyClientResponse)requestSender.send((reactorRequest, nettyOutbound) -> this.send(headers, body2, (HttpClientRequest)reactorRequest, (NettyOutbound)nettyOutbound)).responseConnection((reactorResponse, connection) -> Mono.just((Object)new ReactorNettyClientResponse((HttpClientResponse)reactorResponse, (Connection)connection, this.readTimeout))).next().block(this.exchangeTimeout);
            if (result2 == null) {
                throw new IOException("HTTP exchange resulted in no result");
            }
            return result2;
        }
        catch (RuntimeException ex) {
            throw ReactorNettyClientRequest.convertException(ex);
        }
    }

    private Publisher<Void> send(HttpHeaders headers, @Nullable StreamingHttpOutputMessage.Body body2, HttpClientRequest reactorRequest, NettyOutbound nettyOutbound) {
        headers.forEach((BiConsumer<? super String, ? super List<String>>)((BiConsumer<String, List>)(key2, value2) -> reactorRequest.requestHeaders().set(key2, (Iterable)value2)));
        if (body2 != null) {
            AtomicReference<Object> executor = new AtomicReference<Object>();
            return nettyOutbound.withConnection(connection -> executor.set(connection.channel().eventLoop())).send(FlowAdapters.toPublisher(OutputStreamPublisher.create(outputStream -> body2.writeTo(StreamUtils.nonClosing(outputStream)), new ByteBufMapper(nettyOutbound.alloc()), executor.getAndSet(null))));
        }
        return nettyOutbound;
    }

    static IOException convertException(RuntimeException ex) {
        UncheckedIOException uioEx;
        IOException ioEx;
        Throwable cause2 = ex.getCause();
        if (cause2 instanceof IOException) {
            IOException ioEx2 = (IOException)cause2;
            return ioEx2;
        }
        if (cause2 instanceof UncheckedIOException && (ioEx = (uioEx = (UncheckedIOException)cause2).getCause()) != null) {
            return ioEx;
        }
        return new IOException(ex.getMessage(), cause2 != null ? cause2 : ex);
    }

    private static final class ByteBufMapper
    implements OutputStreamPublisher.ByteMapper<ByteBuf> {
        private final ByteBufAllocator allocator;

        public ByteBufMapper(ByteBufAllocator allocator) {
            this.allocator = allocator;
        }

        @Override
        public ByteBuf map(int b2) {
            ByteBuf byteBuf = this.allocator.buffer(1);
            byteBuf.writeByte(b2);
            return byteBuf;
        }

        @Override
        public ByteBuf map(byte[] b2, int off, int len) {
            ByteBuf byteBuf = this.allocator.buffer(len);
            byteBuf.writeBytes(b2, off, len);
            return byteBuf;
        }
    }
}

