/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.OutputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.FastByteArrayOutputStream;

abstract class AbstractBufferingClientHttpRequest
extends AbstractClientHttpRequest {
    private final FastByteArrayOutputStream bufferedOutput = new FastByteArrayOutputStream(1024);

    AbstractBufferingClientHttpRequest() {
    }

    @Override
    protected OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
        return this.bufferedOutput;
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
        byte[] bytes2 = this.bufferedOutput.toByteArrayUnsafe();
        if (headers.getContentLength() < 0L) {
            headers.setContentLength(bytes2.length);
        }
        ClientHttpResponse result2 = this.executeInternal(headers, bytes2);
        this.bufferedOutput.reset();
        return result2;
    }

    protected abstract ClientHttpResponse executeInternal(HttpHeaders var1, byte[] var2) throws IOException;
}

